/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.init.ModBlocks;
import com.onewhohears.onewholibs.util.UtilItem;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WeaponRecipe
implements Recipe<Inventory> {
    private final ResourceLocation id;
    private final String presetId;

    public WeaponRecipe(ResourceLocation id, String presetId) {
        this.id = id;
        this.presetId = presetId;
    }

    public boolean matches(Inventory inventory, Level level) {
        return UtilItem.testRecipe(this.m_7527_(), (Container)inventory);
    }

    public ItemStack assemble(Inventory container) {
        return this.getOutput();
    }

    public NonNullList<ItemStack> getRemainingItems(Inventory inventory) {
        return UtilItem.getRemainingItemsStackIngredients((Container)inventory, this.m_7527_());
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.getOutput().m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.WEAPONS_BLOCK.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public String getWeaponPresetId() {
        return this.presetId;
    }

    public WeaponStats getWeaponData() {
        return WeaponPresets.get().get(this.getWeaponPresetId());
    }

    public int compare(WeaponRecipe other) {
        WeaponStats me = this.getWeaponData();
        WeaponStats you = other.getWeaponData();
        if (me == null || you == null) {
            return 0;
        }
        return me.compare(you);
    }

    public NonNullList<Ingredient> m_7527_() {
        WeaponStats preset = this.getWeaponData();
        if (preset == null) {
            return NonNullList.m_122779_();
        }
        return preset.getIngredients();
    }

    public ItemStack getOutput() {
        WeaponStats preset = this.getWeaponData();
        if (preset == null) {
            return ItemStack.f_41583_;
        }
        return preset.getNewItem();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<WeaponRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("dscombat", "weapon_workbench");

        public WeaponRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            String presetId = serializedRecipe.get("presetId").getAsString();
            return new WeaponRecipe(recipeId, presetId);
        }

        @Nullable
        public WeaponRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String presetId = buffer.m_130277_();
            return new WeaponRecipe(recipeId, presetId);
        }

        public void toNetwork(FriendlyByteBuf buffer, WeaponRecipe recipe) {
            buffer.m_130070_(recipe.presetId);
        }
    }

    public static class Type
    implements RecipeType<WeaponRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "weapon_workbench";

        private Type() {
        }

        public String toString() {
            return ID;
        }
    }
}

