/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.init.ModBlocks;
import com.onewhohears.onewholibs.util.UtilItem;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class VehicleRecipe
implements Recipe<Inventory> {
    private final ResourceLocation id;
    private final String presetId;

    public VehicleRecipe(ResourceLocation id, String presetId) {
        this.id = id;
        this.presetId = presetId;
    }

    public boolean matches(Inventory inventory, Level level) {
        return UtilItem.testRecipe(this.m_7527_(), (Container)inventory);
    }

    public ItemStack assemble(Inventory container) {
        return this.getOutput();
    }

    public NonNullList<ItemStack> getRemainingItems(Inventory inventory) {
        return UtilItem.getRemainingItemsStackIngredients((Container)inventory, this.m_7527_());
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.getOutput().m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.AIRCRAFT_BLOCK.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public String getVehiclePresetId() {
        return this.presetId;
    }

    public VehicleStats getVehicleStats() {
        return (VehicleStats)VehiclePresets.get().get(this.getVehiclePresetId());
    }

    public int getSortFactor() {
        VehicleStats preset = this.getVehicleStats();
        if (preset == null) {
            return 0;
        }
        return preset.getSortFactor();
    }

    public int compare(VehicleRecipe other) {
        if (this.getSortFactor() != other.getSortFactor()) {
            return this.getSortFactor() - other.getSortFactor();
        }
        return this.presetId.compareToIgnoreCase(other.presetId);
    }

    public NonNullList<Ingredient> m_7527_() {
        VehicleStats preset = this.getVehicleStats();
        if (preset == null) {
            return NonNullList.m_122779_();
        }
        return preset.getIngredients();
    }

    public ItemStack getOutput() {
        VehicleStats preset = this.getVehicleStats();
        if (preset == null) {
            return ItemStack.f_41583_;
        }
        return preset.getItem();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<VehicleRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("dscombat", "aircraft_workbench");

        public VehicleRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            String presetId = serializedRecipe.get("presetId").getAsString();
            return new VehicleRecipe(recipeId, presetId);
        }

        @Nullable
        public VehicleRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String presetId = buffer.m_130277_();
            return new VehicleRecipe(recipeId, presetId);
        }

        public void toNetwork(FriendlyByteBuf buffer, VehicleRecipe recipe) {
            buffer.m_130070_(recipe.presetId);
        }
    }

    public static class Type
    implements RecipeType<VehicleRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "aircraft_workbench";

        private Type() {
        }

        public String toString() {
            return ID;
        }
    }
}

