/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.init.ModRecipes;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.util.UtilItem;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class VehiclePartRepairRecipe
extends CustomRecipe {
    public VehiclePartRepairRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, Level level) {
        if (this.getRepairTool(container) == null) {
            return false;
        }
        ItemStack partItem = this.getVehiclePart(container);
        if (partItem == null) {
            return false;
        }
        if (partItem.m_41613_() != 1) {
            return false;
        }
        PartInstance<?> part = this.getPart(partItem);
        if (part == null) {
            return false;
        }
        if (!part.isDamaged()) {
            return false;
        }
        return UtilItem.testRecipe(((PartStats)part.getStats()).getRepairCost(), (Container)container);
    }

    public ItemStack assemble(CraftingContainer container) {
        ItemStack partItem = this.getVehiclePart(container).m_41777_();
        partItem.m_41784_().m_128379_("damaged", false);
        return partItem;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        int repairIndex = this.getRepairToolIndex(container);
        ItemStack repairTool = container.m_8020_(repairIndex).m_41777_();
        repairTool.m_41721_(repairTool.m_41773_() + 5);
        ItemStack partItem = this.getVehiclePart(container);
        PartInstance<?> part = this.getPart(partItem);
        partItem.m_41764_(0);
        NonNullList rem = UtilItem.getRemainingItemsStackIngredients((Container)container, ((PartStats)part.getStats()).getRepairCost());
        if (repairTool.m_41773_() < repairTool.m_41776_()) {
            rem.set(repairIndex, (Object)repairTool);
        } else {
            rem.set(repairIndex, (Object)ItemStack.f_41583_);
        }
        container.m_6211_();
        return rem;
    }

    @Nullable
    public ItemStack getRepairTool(CraftingContainer container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!this.isRepairTool(container.m_8020_(i))) continue;
            return container.m_8020_(i);
        }
        return null;
    }

    protected int getRepairToolIndex(CraftingContainer container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!this.isRepairTool(container.m_8020_(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public ItemStack getVehiclePart(CraftingContainer container) {
        ItemStack part = null;
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!this.isVehiclePart(container.m_8020_(i))) continue;
            if (part == null) {
                part = container.m_8020_(i);
                continue;
            }
            return null;
        }
        return part;
    }

    public boolean isRepairTool(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.VEHICLE_REPAIR_TOOL);
    }

    public boolean isVehiclePart(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.VEHICLE_PART);
    }

    @Nullable
    public PartInstance<?> getPart(ItemStack stack) {
        return UtilPresetParse.parsePartFromItem(stack);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.VEHICLE_PART_REPAIR.get();
    }
}

