/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toserver;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ToServerVehicleSyncAction
extends IPacket {
    private final VehicleSyncAction action;

    public ToServerVehicleSyncAction(VehicleSyncAction action) {
        this.action = action;
    }

    public ToServerVehicleSyncAction(FriendlyByteBuf buffer) {
        this.action = VehicleSyncAction.getAction(buffer.readInt());
        if (this.action != null) {
            this.action.readData(buffer);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.action.getId());
        this.action.writeData(buffer);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            success.set(true);
            if (this.action == null) {
                return;
            }
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Entity patt1275$temp = player.m_20201_();
            if (!(patt1275$temp instanceof EntityVehicle)) {
                return;
            }
            EntityVehicle vehicle = (EntityVehicle)patt1275$temp;
            if (this.action.hasPermission((Player)player, vehicle)) {
                this.action.runServerAction(player, vehicle);
            }
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

