/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientWeaponImpact
extends IPacket {
    public final WeaponStats.WeaponClientImpactType impactType;
    public final Vec3 pos;

    public ToClientWeaponImpact(EntityWeapon<?> weapon, Vec3 pos) {
        this.impactType = weapon.getClientImpactType();
        this.pos = pos;
    }

    public ToClientWeaponImpact(FriendlyByteBuf buffer) {
        this.impactType = WeaponStats.WeaponClientImpactType.getByOrdinal(buffer.readInt());
        this.pos = (Vec3)DataSerializers.VEC3.m_6709_(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.impactType.ordinal());
        DataSerializers.VEC3.m_6856_(buffer, (Object)this.pos);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.weaponImpact(this.impactType, this.pos);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

