/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientRemovePart
extends IPacket {
    public final int id;
    public final String slotId;

    public ToClientRemovePart(int id, String slotId) {
        this.id = id;
        this.slotId = slotId;
    }

    public ToClientRemovePart(FriendlyByteBuf buffer) {
        super(buffer);
        this.id = buffer.readInt();
        this.slotId = buffer.m_130277_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.m_130070_(this.slotId);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.removePartPacket(this.id, this.slotId);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

