/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientDebugHitboxPos
extends IPacket {
    private final int id;
    private final String hitbox_name;
    private final Vec3 pos;
    private final Vec3 size;

    public ToClientDebugHitboxPos(EntityVehicle vehicle, String hitbox_name, Vec3 pos, Vec3 size) {
        this.id = vehicle.m_19879_();
        this.hitbox_name = hitbox_name;
        this.pos = pos;
        this.size = size;
    }

    public ToClientDebugHitboxPos(FriendlyByteBuf buffer) {
        super(buffer);
        this.id = buffer.readInt();
        this.hitbox_name = buffer.m_130277_();
        this.pos = (Vec3)DataSerializers.VEC3.m_6709_(buffer);
        this.size = (Vec3)DataSerializers.VEC3.m_6709_(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.m_130070_(this.hitbox_name);
        DataSerializers.VEC3.m_6856_(buffer, (Object)this.pos);
        DataSerializers.VEC3.m_6856_(buffer, (Object)this.size);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.debugHitboxPos(this.id, this.hitbox_name, this.pos, this.size);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

