/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;

public class WeaponArgument
implements ArgumentType<String> {
    private static final DynamicCommandExceptionType ERROR_WEAPON_NOT_FOUND = new DynamicCommandExceptionType(arg -> UtilMCText.translatable((String)"error.weapon.notFound", (Object[])new Object[]{arg}));

    public static WeaponArgument weapon() {
        return new WeaponArgument();
    }

    public static WeaponStats getWeapon(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        String w = (String)context.getArgument(name, String.class);
        WeaponStats data = WeaponPresets.get().get(w);
        if (data == null) {
            throw ERROR_WEAPON_NOT_FOUND.create((Object)w);
        }
        return data;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return reader.readUnquotedString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return context.getSource() instanceof SharedSuggestionProvider ? SharedSuggestionProvider.m_82967_((String[])WeaponPresets.get().getAllIds(), (SuggestionsBuilder)builder) : Suggestions.empty();
    }
}

