/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.sounds;

import com.onewhohears.dscombat.client.sounds.DopplerSoundInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;

public class VehicleEngineSoundInstance
extends DopplerSoundInstance {
    public final boolean isPassengerSound;

    public VehicleEngineSoundInstance(SoundEvent sound, LocalPlayer player, EntityVehicle entity, float velSound, boolean isPassengerSound, double range, float minDist) {
        super(sound, player, (Entity)entity, 1.0f, 1.0f, velSound, range, minDist);
        this.isPassengerSound = isPassengerSound;
        if (this.isPassengerSound) {
            this.f_119575_ = 0.0;
            this.f_119576_ = 0.0;
            this.f_119577_ = 0.0;
            this.f_119580_ = SoundInstance.Attenuation.NONE;
            this.f_119582_ = true;
        } else {
            this.f_119580_ = SoundInstance.Attenuation.LINEAR;
            this.f_119582_ = false;
        }
    }

    public VehicleEngineSoundInstance(SoundEvent sound, LocalPlayer player, EntityVehicle entity, float velSound, boolean isPassengerSound) {
        this(sound, player, entity, velSound, isPassengerSound, 128.0, 0.0f);
    }

    @Override
    public void m_7788_() {
        if (this.entity.m_213877_()) {
            this.m_119609_();
            return;
        }
        EntityVehicle craft = (EntityVehicle)this.entity;
        if (craft.getCurrentThrottle() == 0.0f) {
            this.m_119609_();
            return;
        }
        this.calcVolPitch(craft);
        boolean isPassenger = craft.isVehicleOf((Entity)this.player);
        if (this.isPassengerSound && isPassenger) {
            this.f_119573_ = this.initVolume;
            this.f_119574_ = this.initPitch;
        } else if (!this.isPassengerSound && !isPassenger) {
            super.m_7788_();
        } else {
            this.f_119573_ = 0.0f;
        }
    }

    protected void calcVolPitch(EntityVehicle craft) {
        float th = Math.abs(craft.getCurrentThrottle());
        this.initVolume = th == 0.0f ? 0.0f : 0.2f + 0.8f * th;
        this.initPitch = 0.6f + 0.4f * th;
    }
}

