/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.overlay.HudLayoutManager;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityHelicopter;
import com.onewhohears.dscombat.entity.vehicle.EntityPlane;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class HudLayoutEditScreen
extends Screen {
    private final Runnable onSave;
    private float scale;
    private int sw;
    private int sh;
    private EntityVehicle vehicle;
    private boolean isHeli;
    private boolean isPlane;
    private static final String[] IDS = new String[]{"att", "head", "br", "bl"};
    private final Map<String, HudLayoutManager.Rect> rects = new HashMap<String, HudLayoutManager.Rect>();
    private String draggingId = null;
    private boolean resizing = false;
    private double dragDX = 0.0;
    private double dragDY = 0.0;
    private static final int HANDLE = 12;

    public HudLayoutEditScreen(Runnable onSave) {
        super((Component)Component.m_237115_((String)"screen.dscombat.hud_layout_edit"));
        this.onSave = onSave;
    }

    protected void m_7856_() {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        this.scale = ((Double)Config.CLIENT.modernHudScale.get()).floatValue();
        this.sw = (int)((float)this.f_96543_ / this.scale);
        this.sh = (int)((float)this.f_96544_ / this.scale);
        this.vehicle = null;
        if (mc.f_91074_ != null && (entity = mc.f_91074_.m_20201_()) instanceof EntityVehicle) {
            EntityVehicle v;
            this.vehicle = v = (EntityVehicle)entity;
        }
        if (this.vehicle == null) {
            this.m_7379_();
            return;
        }
        this.isHeli = this.vehicle instanceof EntityHelicopter;
        this.isPlane = this.vehicle instanceof EntityPlane;
        int defAttW = 180;
        int defAttH = 110;
        int defAttX = this.sw / 2 - defAttW / 2;
        int defAttY = this.sh / 2 - defAttH / 2 + 12;
        int defHrW = 220;
        int defHrH = 18;
        int defHrX = this.sw / 2 - defHrW / 2;
        int defHrY = defAttY - defHrH - 4;
        int defBrW = 190;
        int defBrH = 96;
        int defBrX = this.sw - defBrW - 10;
        int defBrY = this.sh - defBrH - 10;
        int defBlW = 220;
        int defBlH = 110;
        int defBlX = 10;
        int defBlY = this.sh - defBlH - 10;
        this.rects.put("att", HudLayoutManager.get(this.vt(), "att", new HudLayoutManager.Rect((double)defAttX / (double)this.sw, (double)defAttY / (double)this.sh, (double)defAttW / (double)this.sw, (double)defAttH / (double)this.sh)));
        this.rects.put("head", HudLayoutManager.get(this.vt(), "head", new HudLayoutManager.Rect((double)defHrX / (double)this.sw, (double)defHrY / (double)this.sh, (double)defHrW / (double)this.sw, (double)defHrH / (double)this.sh)));
        this.rects.put("br", HudLayoutManager.get(this.vt(), "br", new HudLayoutManager.Rect((double)defBrX / (double)this.sw, (double)defBrY / (double)this.sh, (double)defBrW / (double)this.sw, (double)defBrH / (double)this.sh)));
        this.rects.put("bl", HudLayoutManager.get(this.vt(), "bl", new HudLayoutManager.Rect((double)defBlX / (double)this.sw, (double)defBlY / (double)this.sh, (double)defBlW / (double)this.sw, (double)defBlH / (double)this.sh)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 130, 10, 120, 20, (Component)Component.m_237113_((String)"Save & Close"), b -> this.closeAndSave()));
    }

    private String vt() {
        if (this.vehicle instanceof EntityHelicopter) {
            return "HELICOPTER";
        }
        if (this.vehicle instanceof EntityPlane) {
            return "PLANE";
        }
        if (((VehicleStats)this.vehicle.getStats()).isBoat()) {
            return "BOAT";
        }
        return "GENERIC";
    }

    public void m_6305_(PoseStack ps, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(ps);
        ps.m_85836_();
        ps.m_85841_(this.scale, this.scale, 1.0f);
        HudLayoutEditScreen.m_93243_((PoseStack)ps, (Font)this.f_96547_, (Component)Component.m_237113_((String)"HUD Layout Edit"), (int)8, (int)8, (int)Color.WHITE.getRGB());
        HudLayoutEditScreen.m_93243_((PoseStack)ps, (Font)this.f_96547_, (Component)Component.m_237113_((String)"Drag to move, drag corner to resize. F6 or button to save."), (int)8, (int)20, (int)0xCCCCCC);
        this.drawRect(ps, "att", 0x66FFFFFF, -1426063361);
        this.drawRect(ps, "head", 0x66FFFFFF, -1426063361);
        this.drawRect(ps, "br", 0x66FFFFFF, -1426063361);
        this.drawRect(ps, "bl", 0x66FFFFFF, -1426063361);
        ps.m_85849_();
        super.m_6305_(ps, mouseX, mouseY, partialTick);
    }

    private void drawRect(PoseStack ps, String id, int border, int handle) {
        HudLayoutManager.Rect r = this.rects.get(id);
        int x = (int)Math.round(r.x * (double)this.sw);
        int y = (int)Math.round(r.y * (double)this.sh);
        int w = (int)Math.round(r.w * (double)this.sw);
        int h = (int)Math.round(r.h * (double)this.sh);
        HudLayoutEditScreen.m_93172_((PoseStack)ps, (int)(x - 1), (int)(y - 1), (int)(x + w + 1), (int)y, (int)border);
        HudLayoutEditScreen.m_93172_((PoseStack)ps, (int)(x - 1), (int)(y + h), (int)(x + w + 1), (int)(y + h + 1), (int)border);
        HudLayoutEditScreen.m_93172_((PoseStack)ps, (int)(x - 1), (int)y, (int)x, (int)(y + h), (int)border);
        HudLayoutEditScreen.m_93172_((PoseStack)ps, (int)(x + w), (int)y, (int)(x + w + 1), (int)(y + h), (int)border);
        HudLayoutEditScreen.m_93236_((PoseStack)ps, (Font)this.f_96547_, (String)id, (int)(x + 2), (int)(y - 10), (int)Color.WHITE.getRGB());
        HudLayoutEditScreen.m_93172_((PoseStack)ps, (int)(x + w - 6), (int)(y + h - 6), (int)(x + w + 6), (int)(y + h + 6), (int)handle);
    }

    public boolean m_6375_(double mx, double my, int button) {
        double hx = mx / (double)this.scale;
        double hy = my / (double)this.scale;
        for (String id : IDS) {
            boolean onHandle;
            boolean inside;
            HudLayoutManager.Rect r = this.rects.get(id);
            int x = (int)Math.round(r.x * (double)this.sw);
            int y = (int)Math.round(r.y * (double)this.sh);
            int w = (int)Math.round(r.w * (double)this.sw);
            int h = (int)Math.round(r.h * (double)this.sh);
            boolean bl = inside = hx >= (double)x && hx <= (double)(x + w) && hy >= (double)y && hy <= (double)(y + h);
            if (!inside) continue;
            this.draggingId = id;
            this.resizing = onHandle = hx >= (double)(x + w - 12) && hy >= (double)(y + h - 12);
            this.dragDX = (hx - (double)x) / (double)this.sw;
            this.dragDY = (hy - (double)y) / (double)this.sh;
            return true;
        }
        return super.m_6375_(mx, my, button);
    }

    public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
        if (this.draggingId != null) {
            double hx = mx / (double)this.scale;
            double hy = my / (double)this.scale;
            HudLayoutManager.Rect r = this.rects.get(this.draggingId);
            if (this.resizing) {
                r.w = this.clamp01(hx / (double)this.sw - r.x);
                r.h = this.clamp01(hy / (double)this.sh - r.y);
            } else {
                r.x = this.clamp01(hx / (double)this.sw - this.dragDX);
                r.y = this.clamp01(hy / (double)this.sh - this.dragDY);
            }
            return true;
        }
        return super.m_7979_(mx, my, button, dx, dy);
    }

    public boolean m_6348_(double mx, double my, int button) {
        if (this.draggingId != null) {
            HudLayoutManager.set(this.vt(), this.draggingId, this.rects.get(this.draggingId));
            this.draggingId = null;
            this.resizing = false;
            return true;
        }
        return super.m_6348_(mx, my, button);
    }

    private double clamp01(double v) {
        return v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (DSCKeys.hudLayoutEditKey != null && this.DSCCmp(keyCode, DSCKeys.hudLayoutEditKey)) {
            this.closeAndSave();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private boolean DSCCmp(int keyCode, KeyMapping mapping) {
        return mapping.m_90861_().m_84873_() == keyCode;
    }

    public void closeAndSave() {
        for (Map.Entry<String, HudLayoutManager.Rect> e : this.rects.entrySet()) {
            HudLayoutManager.set(this.vt(), e.getKey(), e.getValue());
        }
        HudLayoutManager.save();
        this.onSave.run();
        this.m_7379_();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(null);
    }
}

