/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.client.model.obj.ObjVehicleModel;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentData;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.util.UtilRender;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RendererWindTunnel
extends EntityRenderer<EntityWindTunnel> {
    public static final ResourceLocation ARROW_TXT = new ResourceLocation("dscombat", "textures/misc/arrow.png");
    private static final RenderType ARROW = RenderType.m_110497_((ResourceLocation)ARROW_TXT);
    private static final float ARROW_LENGTH_SCALE = 10.0f;

    public RendererWindTunnel(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(@NotNull EntityWindTunnel entity, float yaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        if (entity.getSimulatedVehicle().getClientStatsHolder() == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 4.0, 0.0);
        this.drawGlobalAxis(partialTicks, poseStack, buffer, packedLight);
        if (!entity.getHideModel()) {
            ObjVehicleModel model = (ObjVehicleModel)((VehicleClientStats)entity.getSimulatedVehicle().getClientStatsHolder().get()).getModel();
            model.render(entity.getSimulatedVehicle(), poseStack, buffer, packedLight, partialTicks);
            ObjEntityModels.ModelOverrides overrides = model.getModelOverride();
            poseStack.m_85837_((double)(-overrides.translate.m_122239_()), (double)(-overrides.translate.m_122260_()), (double)(-overrides.translate.m_122269_()));
        } else {
            poseStack.m_85845_(entity.getQ());
        }
        this.drawAccs(entity, partialTicks, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    private void drawAccs(@NotNull EntityWindTunnel entity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        EntityVehicle vehicle = entity.getSimulatedVehicle();
        Quaternion q = vehicle.getQBySide();
        Quaternion qi = vehicle.getQBySide();
        qi.m_80157_();
        poseStack.m_85845_(qi);
        float maxForceMag = (float)entity.weightAcc.m_82553_();
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.WHITE, maxForceMag, Vec3.f_82478_, entity.totalAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.BLACK, maxForceMag, Vec3.f_82478_, entity.weightAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.BLUE, maxForceMag, Vec3.f_82478_, entity.thrustAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.RED, maxForceMag, Vec3.f_82478_, entity.dragAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.GREEN, maxForceMag, Vec3.f_82478_, entity.liftAcc);
        for (PhysicsComponentInstance<?> phy : vehicle.getPhysicsInstances()) {
            Vec3 pos = UtilAngles.rotateVector((Vec3)((PhysicsComponentData)phy.getData()).getPos(), (Quaternion)q);
            this.drawAcc(poseStack, buffer, packedLight, UtilRender.YELLOW, maxForceMag, pos, vehicle.getAccFromForce(phy.getDragForce()));
            this.drawAcc(poseStack, buffer, packedLight, UtilRender.CYAN, maxForceMag, pos, vehicle.getAccFromForce(phy.getLiftForce()));
        }
        poseStack.m_85849_();
    }

    private void drawAcc(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int[] color, float maxForceMag, Vec3 pos, Vec3 force) {
        float mag = (float)force.m_82553_();
        Vec3 dir = mag < 0.001f ? force.m_82490_(1000.0).m_82541_() : force.m_82541_();
        this.drawAcc(poseStack, buffer, packedLight, color, pos, dir, mag / maxForceMag * 10.0f);
    }

    private void drawAcc(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int[] color, Vec3 pos, Vec3 dir, float mag) {
        poseStack.m_85836_();
        poseStack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        float y = UtilAngles.getYaw((Vec3)dir);
        float x = UtilAngles.getPitch((Vec3)dir);
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(y + 180.0f));
        poseStack.m_85845_(Vector3f.f_122222_.m_122240_(x - 90.0f));
        poseStack.m_85837_(0.0, (double)(-mag) * 0.5, 0.0);
        poseStack.m_85841_(1.0f, mag, 1.0f);
        for (int i = 0; i < 4; ++i) {
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_((float)(90 * i)));
            UtilRender.drawTextureCentered(ARROW, poseStack.m_85850_().m_85861_(), buffer, packedLight, 0.0f, color);
        }
        poseStack.m_85849_();
    }

    private void drawGlobalAxis(float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        VertexConsumer buff = buffer.m_6299_(RenderType.m_110504_());
        Vector3f O = new Vector3f();
        Vector3f X = new Vector3f(8.0f, 0.0f, 0.0f);
        Vector3f Y = new Vector3f(0.0f, 8.0f, 0.0f);
        Vector3f Z = new Vector3f(0.0f, 0.0f, 8.0f);
        Matrix4f m4 = poseStack.m_85850_().m_85861_();
        Matrix3f m3 = poseStack.m_85850_().m_85864_();
        UtilRender.drawLine(O, X, buff, m4, m3, UtilRender.RED);
        UtilRender.drawLine(O, Y, buff, m4, m3, UtilRender.GREEN);
        UtilRender.drawLine(O, Z, buff, m4, m3, UtilRender.BLUE);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityWindTunnel entity) {
        return null;
    }
}

