/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.client.model.EntityControllableModel;
import com.onewhohears.dscombat.client.renderer.RotableHitboxRenderer;
import com.onewhohears.dscombat.client.renderer.VehicleScreenRenderer;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class RendererEntityVehicle<T extends EntityVehicle>
extends EntityRenderer<T>
implements RotableHitboxRenderer,
VehicleScreenRenderer<T> {
    protected final EntityControllableModel<T> model;

    public static RenderType getCullBaseRenderType(ResourceLocation texture) {
        return RenderType.m_110470_((ResourceLocation)texture);
    }

    public static RenderType getBaseRenderType(ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }

    public static RenderType getLayerRenderType(ResourceLocation texture) {
        return RenderType.m_110431_((ResourceLocation)texture);
    }

    public RendererEntityVehicle(EntityRendererProvider.Context context, EntityControllableModel<T> model) {
        super(context);
        this.f_114477_ = 0.8f;
        this.model = model;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (!((EntityVehicle)entity).isOperational()) {
            float grey;
            green = blue = (grey = 0.4f);
            red = blue;
        }
        Quaternion q = UtilAngles.lerpQ((float)partialTicks, (Quaternion)((EntityVehicle)entity).getPrevQ(), (Quaternion)((EntityVehicle)entity).getClientQ());
        poseStack.m_85836_();
        poseStack.m_85845_(q);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RendererEntityVehicle.getBaseRenderType(this.getTextureLocation(entity)));
        this.model.renderToBuffer(entity, partialTicks, poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, 1.0f);
        poseStack.m_85849_();
        if (this.shouldDrawRotableHitboxes((EntityVehicle)entity)) {
            this.drawRotableHitboxeOutlines((EntityVehicle)entity, partialTicks, poseStack, bufferSource);
        }
        if (this.shouldRenderScreens(entity)) {
            this.renderVehicleScreens(entity, poseStack, bufferSource, packedLight, partialTicks);
        }
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ((EntityVehicle)entity).textureManager.getDynamicTexture();
    }

    @Override
    public boolean shouldRenderScreens(T vehicle) {
        return false;
    }

    @Override
    public void renderVehicleScreens(T vehicle, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
    }
}

