/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.jetbrains.annotations.NotNull;

public class VehicleThrottleOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation THROTTLE_RAIL = new ResourceLocation("dscombat", "textures/ui/throttle_rail.png");
    public static final ResourceLocation THROTTLE_HANDLE = new ResourceLocation("dscombat", "textures/ui/throttle_handle.png");
    public static final int THROTTLE_RAIL_LENGTH = 70;
    public static final int THROTTLE_WIDTH = 10;
    public static final int THROTTLE_KNOB_HEIGHT = 10;

    @Override
    protected boolean shouldRender(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleThrottleOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        return VehicleThrottleOverlay.getPlayerRootVehicle() instanceof EntityVehicle;
    }

    @Override
    protected void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)VehicleThrottleOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int xOrigin = screenWidth - 60 - 1 - 10 - 1;
        int yOrigin = screenHeight - 70 - 1;
        RenderSystem.m_157456_((int)0, (ResourceLocation)THROTTLE_RAIL);
        VehicleThrottleOverlay.m_93133_((PoseStack)poseStack, (int)xOrigin, (int)yOrigin, (float)0.0f, (float)0.0f, (int)10, (int)70, (int)10, (int)70);
        RenderSystem.m_157456_((int)0, (ResourceLocation)THROTTLE_HANDLE);
        int throttleYPos = yOrigin + 70 - 10;
        int throttleLength = 60;
        float throttle = vehicle.inputs.getGoalThrottle(vehicle);
        throttleYPos = ((VehicleStats)vehicle.getStats()).negativeThrottle ? throttleYPos - throttleLength / 2 - (int)(throttle * (float)throttleLength / 2.0f) : (throttleYPos -= (int)(throttle * (float)throttleLength));
        VehicleThrottleOverlay.m_93133_((PoseStack)poseStack, (int)xOrigin, (int)throttleYPos, (float)0.0f, (float)0.0f, (int)10, (int)10, (int)10, (int)10);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_throttle";
    }
}

