/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.client.overlay.components.VehicleControlOverlay;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.jetbrains.annotations.NotNull;

public class VehicleStatsOverlay
extends VehicleOverlayComponent {
    public static final Color GREEN_ME_SAY_ALONE_RAMP = new Color(0, 255, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final float START = 0.6f;
    public static final float END = 0.1f;
    public static final float CHANGE_G = (float)GREEN_ME_SAY_ALONE_RAMP.getGreen() / 0.5f;
    public static final float CHANGE_R = (float)RED.getRed() / 0.5f;

    public static int getHealthColor(float health, float max) {
        float healthPercent = health / max;
        if (healthPercent >= 0.6f) {
            return GREEN_ME_SAY_ALONE_RAMP.getRGB();
        }
        if (healthPercent < 0.6f && healthPercent > 0.1f) {
            return new Color((int)(CHANGE_R * (0.6f - healthPercent)), (int)(CHANGE_G * (healthPercent - 0.1f)), 0).getRGB();
        }
        return RED.getRGB();
    }

    @Override
    protected boolean shouldRender(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleStatsOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        if (!(VehicleStatsOverlay.getPlayerRootVehicle() instanceof EntityVehicle)) {
            return false;
        }
        return !DSCClientInputs.isCameraLockedForward();
    }

    @Override
    protected void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)VehicleStatsOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int xOrigin = screenWidth - 60 - 1;
        int yOrigin = screenHeight - 60 - 3 - 40 - 10;
        if (vehicle.isAircraft()) {
            yOrigin -= VehicleControlOverlay.PEDAL_HEIGHT;
        }
        VehicleStatsOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)("m/s: " + String.format("%3.1f", vehicle.m_20184_().m_82553_() * 20.0)), (int)xOrigin, (int)yOrigin, (int)65280);
        VehicleStatsOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)("A: " + vehicle.getAltitude()), (int)xOrigin, (int)(yOrigin - 10), (int)65280);
        float health = vehicle.getHealth();
        float maxHealth = vehicle.getMaxHealth();
        VehicleStatsOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)("H: " + (int)health + "/" + (int)maxHealth), (int)xOrigin, (int)(yOrigin - 20), (int)VehicleStatsOverlay.getHealthColor(health, maxHealth));
        float armor = vehicle.getArmor();
        float maxArmor = vehicle.getMaxTotalArmor();
        VehicleStatsOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)("S: " + (int)armor + "/" + (int)maxArmor), (int)xOrigin, (int)(yOrigin - 30), (int)VehicleStatsOverlay.getHealthColor(armor, maxArmor));
        VehicleStatsOverlay.m_93208_((PoseStack)poseStack, (Font)FONT, (String)("[" + vehicle.m_146903_() + "," + vehicle.m_146904_() + "," + vehicle.m_146907_() + "]"), (int)(screenWidth / 2), (int)0, (int)65280);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_stats";
    }
}

