/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.jetbrains.annotations.NotNull;

public class VehicleCompassOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation COMPASS = new ResourceLocation("dscombat", "textures/ui/hud_compass.png");
    public static final short COMPASS_TEXTURE_WIDTH = 720;
    public static final byte COMPASS_TEXTURE_HEIGHT = 16;
    public static final short COMPASS_U_WIDTH = 161;
    public static final byte COMPASS_CORRECTIONAL_OFFSET = 30;

    private static String textByHeading(int h) {
        return switch (h) {
            case 0 -> "S";
            case 180 -> "N";
            case 90 -> "W";
            case 270 -> "E";
            case 45 -> "SW";
            case 135 -> "NW";
            case 225 -> "NE";
            case 315 -> "SE";
            default -> "";
        };
    }

    @Override
    protected boolean shouldRender(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleCompassOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        return VehicleCompassOverlay.getPlayerRootVehicle() instanceof EntityVehicle;
    }

    @Override
    protected void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        int y = 10;
        int color = 0xE6E600;
        assert (Minecraft.m_91087_().f_91074_ != null);
        float heading = Mth.m_14177_((float)Minecraft.m_91087_().f_91074_.m_146908_());
        if (heading < 0.0f) {
            heading += 360.0f;
        }
        String stringHeading = !Objects.equals(VehicleCompassOverlay.textByHeading((int)heading), "") ? VehicleCompassOverlay.textByHeading((int)heading) : String.valueOf((int)heading);
        VehicleCompassOverlay.m_93208_((PoseStack)poseStack, (Font)FONT, (String)stringHeading, (int)(screenWidth / 2), (int)(y + 40), (int)color);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)COMPASS);
        poseStack.m_85836_();
        poseStack.m_85837_((double)(screenWidth - 161) / 2.0 - 1.0, 30.0, 0.0);
        VehicleCompassOverlay.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)(Minecraft.m_91087_().f_91074_.m_146908_() * 2.0f - 30.0f), (float)0.0f, (int)161, (int)16, (int)720, (int)16);
        poseStack.m_85849_();
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_compass";
    }
}

