/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.jetbrains.annotations.NotNull;

public class PosRangeOverlay
extends VehicleOverlayComponent {
    @Override
    protected boolean shouldRender(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (DSCClientInputs.getTargetMode() == DSCClientInputs.TargetMode.LOOK) {
            return false;
        }
        if (PosRangeOverlay.defaultRenderConditions()) {
            return false;
        }
        Entity entity = PosRangeOverlay.getPlayerRootVehicle();
        if (!(entity instanceof EntityVehicle)) {
            return false;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        if (data == null) {
            return false;
        }
        return ((WeaponStats)data.getStats()).isPosGuided();
    }

    @Override
    protected void render(ForgeGui gui, PoseStack stack, float partialTick, int screenWidth, int screenHeight) {
        int color;
        Entity entity = PosRangeOverlay.getPlayerRootVehicle();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        assert (data != null);
        double range = ((WeaponStats)data.getStats()).getMobTurretRange();
        Vec3 pos = Config.CLIENT.getTargetPos();
        int dist = (int)pos.m_82554_(vehicle.m_20182_());
        int alt = UtilEntity.getDistFromSeaLevel((double)pos.f_82480_, (Level)vehicle.f_19853_);
        String text = dist + " | " + alt;
        if ((double)dist <= range) {
            color = 65280;
            text = text + " | O";
        } else {
            color = 0xFF0000;
            text = text + " | X";
        }
        PosRangeOverlay.m_93208_((PoseStack)stack, (Font)FONT, (String)text, (int)(screenWidth / 2), (int)(screenHeight / 2 - 20), (int)color);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_pos_range";
    }
}

