/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityHelicopter;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.jetbrains.annotations.NotNull;

public class HeliStatusOverlay
extends VehicleOverlayComponent {
    private static final int TEXT_COLOR = new Color(65280).getRGB();
    private static final int WARN_COLOR = new Color(0xFFAA00).getRGB();
    private static final int DANGER_COLOR = new Color(0xFF3333).getRGB();
    private static final int OFF_COLOR = new Color(0x888888).getRGB();

    @Override
    protected boolean shouldRender(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (HeliStatusOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        return HeliStatusOverlay.getPlayerRootVehicle() instanceof EntityHelicopter;
    }

    @Override
    protected void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityHelicopter heli = (EntityHelicopter)HeliStatusOverlay.getPlayerRootVehicle();
        assert (heli != null);
        int x = 6;
        int y = screenHeight - 70;
        double rpm = Math.max(0.0, Math.min(1.0, heli.getRotorPower())) * 100.0;
        HeliStatusOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)String.format("RPM: %3.0f%%", rpm), (int)x, (int)y, (int)TEXT_COLOR);
        y += 10;
        double hMax = (Double)Config.SERVER.groundEffectMaxHeight.get();
        boolean ige = false;
        if (((Boolean)Config.SERVER.enableGroundEffect.get()).booleanValue() && hMax > 0.0) {
            int limit = (int)Math.ceil(hMax) + 1;
            int aglBlocks = UtilVehicleEntity.getDistFromGround((Entity)heli, limit, true);
            ige = (double)aglBlocks < hMax;
        }
        HeliStatusOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)("IGE: " + (ige ? "ON" : "OFF")), (int)x, (int)y, (int)(ige ? TEXT_COLOR : OFF_COLOR));
        double speedXZ = heli.m_20184_().m_165924_();
        double etlFull = Math.max(1.0E-6, (Double)Config.SERVER.translationalLiftFullSpeed.get());
        double etlFactor = Math.min(1.0, speedXZ / etlFull);
        boolean etl = (Boolean)Config.SERVER.enableTranslationalLift.get() != false && etlFactor > 0.05;
        HeliStatusOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)("ETL: " + (etl ? String.format("%d%%", (int)(etlFactor * 100.0)) : "OFF")), (int)x, (int)(y += 10), (int)(etl ? WARN_COLOR : OFF_COLOR));
        y += 10;
        double vy = heli.m_20184_().f_82480_;
        double descent = vy < 0.0 ? -vy : 0.0;
        double vrsTrig = (Double)Config.SERVER.vrsDescentTrigger.get();
        double vrsMaxSpeed = (Double)Config.SERVER.vrsHorizMaxSpeed.get();
        boolean vrs = (Boolean)Config.SERVER.enableVRS.get() != false && descent > vrsTrig && speedXZ < vrsMaxSpeed;
        HeliStatusOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)("VRS: " + (vrs ? "ENGAGED" : "OK")), (int)x, (int)y, (int)(vrs ? DANGER_COLOR : TEXT_COLOR));
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_heli_status";
    }
}

