/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.util.UtilPrint;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WindTunnelOverlay
extends GuiComponent {
    static final long CHECK_TUNNEL_RATE = 2000L;
    static long prevTunnelCheckTime = System.currentTimeMillis();
    static final int VALUE_OFFSET = 50;
    static final int LABEL_PADDING = 2;
    @Nullable
    static EntityWindTunnel tunnel;

    public static void register(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("dscombat_wind_tunnel", WindTunnelOverlay::render);
    }

    static void render(ForgeGui gui, PoseStack stack, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_20310_(2)) {
            return;
        }
        if (System.currentTimeMillis() - prevTunnelCheckTime >= 2000L) {
            WindTunnelOverlay.findTunnel(player.m_20182_(), player.m_9236_());
        }
        if (tunnel == null) {
            return;
        }
        int index = 0;
        gui.m_93082_().m_92883_(stack, tunnel.getStatsId(), 2.0f, 2.0f, 65280);
        gui.m_93082_().m_92883_(stack, "Speed", 2.0f, (float)(2 + 10 * ++index), 65535);
        gui.m_93082_().m_92883_(stack, UtilPrint.printVec3SigFig(tunnel.getSpeed()), 50.0f, (float)(2 + 10 * index), 65535);
        gui.m_93082_().m_92883_(stack, "Total", 2.0f, (float)(2 + 10 * ++index), 0xFFFFFF);
        gui.m_93082_().m_92883_(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.totalAcc), 50.0f, (float)(2 + 10 * index), 0xFFFFFF);
        gui.m_93082_().m_92883_(stack, "Thrust", 2.0f, (float)(2 + 10 * ++index), 255);
        gui.m_93082_().m_92883_(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.thrustAcc), 50.0f, (float)(2 + 10 * index), 255);
        gui.m_93082_().m_92883_(stack, "Drag", 2.0f, (float)(2 + 10 * ++index), 0xFF0000);
        gui.m_93082_().m_92883_(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.dragAcc), 50.0f, (float)(2 + 10 * index), 0xFF0000);
        gui.m_93082_().m_92883_(stack, "Lift", 2.0f, (float)(2 + 10 * ++index), 65280);
        gui.m_93082_().m_92883_(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.liftAcc), 50.0f, (float)(2 + 10 * index), 65280);
        gui.m_93082_().m_92883_(stack, "Weight", 2.0f, (float)(2 + 10 * ++index), 0);
        gui.m_93082_().m_92883_(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.weightAcc), 50.0f, (float)(2 + 10 * index), 0);
        gui.m_93082_().m_92883_(stack, "RotAcc", 2.0f, (float)(2 + 10 * ++index), 255);
        gui.m_93082_().m_92883_(stack, UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.rotAcc), 50.0f, (float)(2 + 10 * index), 255);
        gui.m_93082_().m_92883_(stack, "AOA", 2.0f, (float)(2 + 10 * ++index), 0xFF00FF);
        StringBuilder aoaStr = new StringBuilder();
        for (Float aoa : WindTunnelOverlay.tunnel.aoas) {
            aoaStr.append(UtilPrint.printDec(aoa.floatValue())).append(" ");
        }
        gui.m_93082_().m_92883_(stack, aoaStr.toString(), 50.0f, (float)(2 + 10 * index), 0xFF00FF);
        int color = 65280;
        if (WindTunnelOverlay.tunnel.windCompAcc < 0.0) {
            color = 0xFF0000;
        }
        gui.m_93082_().m_92883_(stack, "WCA", 2.0f, (float)(2 + 10 * ++index), color);
        gui.m_93082_().m_92883_(stack, UtilPrint.printSigFig(WindTunnelOverlay.tunnel.windCompAcc), 50.0f, (float)(2 + 10 * index), color);
        double Ny = WindTunnelOverlay.tunnel.centripetalAcc / 0.024525;
        gui.m_93082_().m_92883_(stack, "Ny", 2.0f, (float)(2 + 10 * ++index), 0xFFFF00);
        gui.m_93082_().m_92883_(stack, UtilPrint.printSigFig(Ny), 50.0f, (float)(2 + 10 * index), 0xFFFF00);
        gui.m_93082_().m_92883_(stack, "YawRate", 2.0f, (float)(2 + 10 * ++index), 0xFF00FF);
        gui.m_93082_().m_92883_(stack, UtilPrint.printDec(WindTunnelOverlay.tunnel.yawRate * 20.0), 50.0f, (float)(2 + 10 * index), 0xFF00FF);
        gui.m_93082_().m_92883_(stack, "TurnRad", 2.0f, (float)(2 + 10 * ++index), 65535);
        gui.m_93082_().m_92883_(stack, UtilPrint.printDec(WindTunnelOverlay.tunnel.turnRadius), 50.0f, (float)(2 + 10 * index), 65535);
    }

    static void findTunnel(Vec3 pos, Level level) {
        Optional<EntityWindTunnel> opt = UtilVehicleEntity.findWindTunnel(pos, level);
        tunnel = opt.orElse(null);
        prevTunnelCheckTime = System.currentTimeMillis();
    }
}

