/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj.custom;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.client.model.obj.ObjVehicleModel;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraftforge.client.model.renderable.CompositeRenderable;

public class JasonPlaneModel
extends ObjVehicleModel<EntityVehicle> {
    private static final Vector3f PIVOT = new Vector3f(0.0f, -2.0f, 0.0f);

    public JasonPlaneModel() {
        super("jason_plane");
    }

    protected CompositeRenderable.Transforms getComponentTransforms(EntityVehicle entity, float partialTicks) {
        Matrix4f right_flap;
        Matrix4f left_flap;
        Matrix4f lg0_mat;
        Matrix4f lg1_mat;
        Matrix4f lg2_mat;
        float bladerot = entity.getMotorRotation(partialTicks, 20.0f);
        Matrix4f blade0_mat = UtilAngles.pivotPixelsRotZ((float)-0.0426f, (float)42.0581f, (float)82.8989f, (float)bladerot);
        float gearpos = entity.getLandingGearPos(partialTicks);
        if (gearpos >= 1.0f) {
            lg1_mat = lg2_mat = INVISIBLE;
            lg0_mat = lg2_mat;
        } else {
            float degrees = gearpos * 90.0f;
            lg0_mat = UtilAngles.pivotPixelsRotZ((float)39.5712f, (float)28.6068f, (float)25.0786f, (float)(-degrees));
            lg1_mat = UtilAngles.pivotPixelsRotZ((float)-39.5712f, (float)28.6068f, (float)25.0786f, (float)degrees);
            lg2_mat = UtilAngles.pivotPixelsRotX((float)0.0f, (float)34.8817f, (float)-71.9732f, (float)degrees);
        }
        Matrix4f rudder = UtilAngles.pivotPixelsRotY((float)0.0f, (float)55.8305f, (float)-107.139f, (float)(entity.inputs.yaw * 15.0f));
        Matrix4f left_elevator = UtilAngles.pivotPixelsRotX((float)20.9161f, (float)50.9701f, (float)-99.3629f, (float)(entity.inputs.pitch * 22.0f));
        Matrix4f right_elevator = UtilAngles.pivotPixelsRotX((float)-20.9161f, (float)50.9701f, (float)-99.3629f, (float)(entity.inputs.pitch * 22.0f));
        if (entity.isFlapsDown()) {
            left_flap = UtilAngles.pivotPixelsRotX((float)94.4596f, (float)36.7061f, (float)-0.8385f, (float)-22.0f);
            right_flap = UtilAngles.pivotPixelsRotX((float)-94.4596f, (float)36.7061f, (float)-0.8385f, (float)-22.0f);
        } else {
            left_flap = UtilAngles.pivotPixelsRotX((float)94.4596f, (float)36.7061f, (float)-0.8385f, (float)(entity.inputs.roll * -22.0f));
            right_flap = UtilAngles.pivotPixelsRotX((float)-94.4596f, (float)36.7061f, (float)-0.8385f, (float)(entity.inputs.roll * 22.0f));
        }
        Quaternion stickRot = Vector3f.f_122223_.m_122240_(entity.inputs.pitch * -25.0f);
        stickRot.m_80148_(Vector3f.f_122227_.m_122240_(entity.inputs.roll * 25.0f));
        Matrix4f stick = UtilAngles.pivotPixelsRot((float)0.0f, (float)33.8882f, (float)4.717f, (Quaternion)stickRot);
        Matrix4f throttle = Matrix4f.m_27653_((float)0.0f, (float)0.0f, (float)(entity.getCurrentThrottle() * 0.125f));
        Matrix4f left_pedal = Matrix4f.m_27653_((float)0.0f, (float)0.0f, (float)(entity.inputs.yaw * -0.0625f));
        Matrix4f right_pedal = Matrix4f.m_27653_((float)0.0f, (float)0.0f, (float)(entity.inputs.yaw * 0.0625f));
        ImmutableMap transforms = ImmutableMap.builder().put((Object)"lg0", (Object)lg0_mat).put((Object)"lg1", (Object)lg1_mat).put((Object)"lg2", (Object)lg2_mat).put((Object)"blade0", (Object)blade0_mat).put((Object)"surface0", (Object)rudder).put((Object)"surface1", (Object)left_flap).put((Object)"surface2", (Object)right_flap).put((Object)"surface3", (Object)left_elevator).put((Object)"surface4", (Object)right_elevator).put((Object)"stick", (Object)stick).put((Object)"throttle", (Object)throttle).put((Object)"pedal0", (Object)left_pedal).put((Object)"pedal1", (Object)right_pedal).build();
        return CompositeRenderable.Transforms.of((ImmutableMap)transforms);
    }

    public Vector3f getGlobalPivot() {
        return PIVOT;
    }
}

