/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.client.model.obj.ObjPartModel;
import com.onewhohears.dscombat.entity.parts.EntityChainHook;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ChainHookModel
extends ObjPartModel<EntityChainHook> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("dscombat:textures/entity/part/chain.png");

    public ChainHookModel(String modelId) {
        super(modelId);
    }

    @Override
    public void render(EntityChainHook entity, PoseStack poseStack, MultiBufferSource bufferSource, int lightmap, float partialTicks) {
        if (entity.getConnections().size() != 0) {
            poseStack.m_85836_();
            VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)TEXTURE));
            Quaternion hookPosRot = Vector3f.f_122227_.m_122240_(entity.getZRot());
            Vec3 chainOffset = UtilAngles.rotateVector((Vec3)new Vec3(0.0, 0.45, 0.0), (Quaternion)hookPosRot);
            if (entity.getParentVehicle() != null) {
                chainOffset = UtilAngles.rotateVector((Vec3)chainOffset, (Quaternion)entity.getParentVehicle().getClientQ(partialTicks));
            }
            Vec3 hookPos = entity.m_20318_(partialTicks).m_82549_(chainOffset);
            poseStack.m_85837_(chainOffset.f_82479_, chainOffset.f_82480_, chainOffset.f_82481_);
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            for (EntityChainHook.ChainConnection chain : entity.getConnections()) {
                Entity connector = chain.getEntity();
                if (connector == null || connector.m_213877_()) continue;
                Vec3 connPos = connector.m_20318_(partialTicks);
                Vec3 chainDiff = connPos.m_82520_(0.0, 1.0, 0.0).m_82546_(hookPos);
                Vec3 chainDiffNorm = chainDiff.m_82541_();
                Vec3 pitchAxis = UtilAngles.rotateVector((Vec3)chainDiffNorm, (Quaternion)Vector3f.f_122225_.m_122240_(90.0f));
                Vec3 yawAxis = UtilAngles.rotateVector((Vec3)chainDiffNorm, (Quaternion)Vector3f.f_122222_.m_122240_(90.0f));
                float t = 0.1f;
                float l = (float)(chainDiff.m_82553_() / 8.0);
                this.drawChainSide(vertexconsumer, matrix4f, chainDiff, pitchAxis, t, l, lightmap);
                this.drawChainSide(vertexconsumer, matrix4f, chainDiff, pitchAxis.m_82490_(-1.0), t, l, lightmap);
                this.drawChainSide(vertexconsumer, matrix4f, chainDiff, yawAxis, t, l, lightmap);
                this.drawChainSide(vertexconsumer, matrix4f, chainDiff, yawAxis.m_82490_(-1.0), t, l, lightmap);
            }
            poseStack.m_85849_();
        }
        super.render(entity, poseStack, bufferSource, lightmap, partialTicks);
    }

    private void drawChainSide(VertexConsumer vertexconsumer, Matrix4f matrix4f, Vec3 chainDiff, Vec3 axis, float t, float l, int lightmap) {
        vertexconsumer.m_85982_(matrix4f, (float)(-axis.f_82479_) * t, (float)(-axis.f_82480_) * t, (float)(-axis.f_82481_) * t).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(lightmap).m_5752_();
        vertexconsumer.m_85982_(matrix4f, (float)(chainDiff.f_82479_ - axis.f_82479_ * (double)t), (float)(chainDiff.f_82480_ - axis.f_82480_ * (double)t), (float)(chainDiff.f_82481_ - axis.f_82481_ * (double)t)).m_6122_(255, 255, 255, 255).m_7421_(l, 0.0f).m_85969_(lightmap).m_5752_();
        vertexconsumer.m_85982_(matrix4f, (float)(chainDiff.f_82479_ + axis.f_82479_ * (double)t), (float)(chainDiff.f_82480_ + axis.f_82480_ * (double)t), (float)(chainDiff.f_82481_ + axis.f_82481_ * (double)t)).m_6122_(255, 255, 255, 255).m_7421_(l, 1.0f).m_85969_(lightmap).m_5752_();
        vertexconsumer.m_85982_(matrix4f, (float)axis.f_82479_ * t, (float)axis.f_82480_ * t, (float)axis.f_82481_ * t).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(lightmap).m_5752_();
    }
}

