/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen;

import com.onewhohears.dscombat.client.entityscreen.instance.EntityScreenInstance;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;

public class EntityScreenTypes {
    public static final Int2ObjectMap<EntityScreenFactory> screenTypes = new Int2ObjectOpenHashMap();
    private static final Map<Integer, Integer> colorsToScreenTypeId = new HashMap<Integer, Integer>();

    public static void addScreenType(int id, EntityScreenFactory factory, String screenMapColorRGB) {
        screenTypes.put(id, (Object)factory);
        if (!screenMapColorRGB.isEmpty()) {
            colorsToScreenTypeId.put(EntityScreenTypes.stringRGBToIntABGR(screenMapColorRGB), id);
        }
    }

    public static int getScreenTypeIdByColor(int abgrColor) {
        if (!colorsToScreenTypeId.containsKey(abgrColor)) {
            return -1;
        }
        return colorsToScreenTypeId.get(abgrColor);
    }

    public static int stringRGBToIntABGR(String rgb) {
        if (!((String)rgb).startsWith("0x")) {
            rgb = "0x" + (String)rgb;
        }
        int rgba = ((String)rgb).substring(2).length() < 8 ? Long.decode((String)rgb + "FF").intValue() : Long.decode((String)rgb).intValue();
        return Integer.reverseBytes(rgba);
    }

    public static interface EntityScreenFactory {
        public EntityScreenInstance create(int var1);
    }
}

