/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat;

import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.DoubleValue mouseModeMaxRadius;
        public final ForgeConfigSpec.DoubleValue mouseYReturnRate;
        public final ForgeConfigSpec.DoubleValue mouseXReturnRate;
        public final ForgeConfigSpec.IntValue mouseYSteps;
        public final ForgeConfigSpec.IntValue mouseXSteps;
        public final ForgeConfigSpec.BooleanValue invertY;
        public final ForgeConfigSpec.BooleanValue cameraTurnRelativeToVehicle;
        public final ForgeConfigSpec.BooleanValue customDismount;
        public final ForgeConfigSpec.DoubleValue targetPosX;
        public final ForgeConfigSpec.DoubleValue targetPosY;
        public final ForgeConfigSpec.DoubleValue targetPosZ;
        public final ForgeConfigSpec.DoubleValue rwrWarningVol;
        public final ForgeConfigSpec.DoubleValue missileWarningVol;
        public final ForgeConfigSpec.DoubleValue irTargetToneVol;
        public final ForgeConfigSpec.DoubleValue cockpitVoiceLineVol;
        public final ForgeConfigSpec.ConfigValue<String> passengerSoundPack;
        public final ForgeConfigSpec.IntValue radarPingOverlaySize;
        public final ForgeConfigSpec.EnumValue<RadarStats.RadarMode> defaultRadarMode;
        public final ForgeConfigSpec.IntValue maxRenderRackMissileNum;
        public final ForgeConfigSpec.DoubleValue renderWeaponRackDistance;
        public final ForgeConfigSpec.DoubleValue renderTurretDistance;
        public final ForgeConfigSpec.DoubleValue renderEngineDistance;
        public final ForgeConfigSpec.DoubleValue renderRadarDistance;
        public final ForgeConfigSpec.DoubleValue renderOtherExternalPartDistance;
        public final ForgeConfigSpec.BooleanValue debugMode;
        public final ForgeConfigSpec.IntValue syncSeatPosRate;
        public final ForgeConfigSpec.BooleanValue enableModernHUD;
        public final ForgeConfigSpec.DoubleValue modernHudOpacity;
        public final ForgeConfigSpec.DoubleValue modernHudScale;
        public final ForgeConfigSpec.ConfigValue<String> hudSpeedUnit;
        public final ForgeConfigSpec.ConfigValue<String> hudAltUnit;
        public final ForgeConfigSpec.BooleanValue showControlsInModernHUD;
        public final ForgeConfigSpec.BooleanValue enableHeliInputSmoothing;
        public final ForgeConfigSpec.DoubleValue heliPitchSmoothingStep;
        public final ForgeConfigSpec.DoubleValue heliRollSmoothingStep;
        public final ForgeConfigSpec.DoubleValue heliYawSmoothingStep;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("display");
            this.radarPingOverlaySize = builder.defineInRange("radarPingOverlaySize", 100, 10, 1000);
            this.defaultRadarMode = builder.defineEnum("defaultRadarMode", (Enum)RadarStats.RadarMode.ALL);
            builder.pop();
            builder.push("mouse-joystick-settings");
            this.mouseModeMaxRadius = builder.comment("Only for vehicles in Mouse Mode. How far your mouse must move from rest to get a maximum angle.").defineInRange("mouseModeMaxRadius", 400.0, 0.0, 10000.0);
            this.mouseYReturnRate = builder.comment("Speed the control stick vertically snaps back to rest when mouse isn't moving.").defineInRange("stickPitchReturnRate", 0.0, 0.0, 100.0);
            this.mouseXReturnRate = builder.comment("Speed the control stick horizontally snaps back to rest when mouse isn't moving.").defineInRange("stickRollReturnRate", 40.0, 0.0, 100.0);
            this.mouseYSteps = builder.defineInRange("stickPitchSteps", 5, 1, 100);
            this.mouseXSteps = builder.defineInRange("stickRollSteps", 5, 1, 100);
            builder.pop();
            builder.push("control");
            this.invertY = builder.comment("Invert vertical inputs.").define("invertY", false);
            this.cameraTurnRelativeToVehicle = builder.comment("If enabled, turning your player head may feel more natural.").define("cameraTurnRelativeToVehicle", true);
            this.customDismount = builder.comment("If enabled, your sneak key binding doesn't dismount you from DSC vehicles. You will have to you the diamond star combat dismount keybinding instead (H by default.)").define("customDismount", true);
            builder.push("targetPos");
            this.targetPosX = builder.defineInRange("targetPosX", 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
            this.targetPosY = builder.defineInRange("targetPosY", 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
            this.targetPosZ = builder.defineInRange("targetPosZ", 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.push("sounds");
            this.rwrWarningVol = builder.comment("RWR Warning Sound Volume").defineInRange("rwrWarningVol", 1.0, 0.0, 1.0);
            this.missileWarningVol = builder.comment("Missile Warning Sound Volume").defineInRange("missileWarningVol", 1.0, 0.0, 1.0);
            this.irTargetToneVol = builder.comment("IR Target Found Sound Volume").defineInRange("irTargetToneVol", 0.5, 0.0, 1.0);
            this.cockpitVoiceLineVol = builder.comment("Cockpit Voicelines Volume").defineInRange("cockpitVoiceLineVol", 1.0, 0.0, 1.0);
            this.passengerSoundPack = builder.comment("The voice line pack your fighter jets use. You can use resource packs to add custom sound packs. The packs that come built into the mod are 'eng_non_binary_goober', 'eng_generic_male'.").define("passengerSoundPack", (Object)"eng_non_binary_goober");
            builder.pop();
            builder.push("performance");
            this.maxRenderRackMissileNum = builder.defineInRange("maxRenderRackMissileNum", 30, 0, 300);
            this.debugMode = builder.comment("Stats for nerds.").define("debugMode", false);
            this.syncSeatPosRate = builder.comment("Sometimes when the server lags, the server side position of the player's seat entity doesn't get updated. Eventually the server thinks the seat is outside of the player's render distance and sends a discard packet. This causes the player to randomly fall out of their plane. This is solved by having the client tell the server explicitly where the seat actually is on the client side. This config controls how often (in ticks) this sync packet is sent from the client to the server. This used to be set to 40 for everyone, but some have exceptionally poor connections and may need this value to be lowered.").defineInRange("syncSeatPosRate", 10, 0, 200);
            builder.push("entity-render-distance");
            this.renderWeaponRackDistance = builder.defineInRange("renderWeaponRackDistance", 256.0, 0.0, 1000.0);
            this.renderTurretDistance = builder.defineInRange("renderTurretDistance", 256.0, 0.0, 1000.0);
            this.renderEngineDistance = builder.defineInRange("renderEngineDistance", 256.0, 0.0, 1000.0);
            this.renderRadarDistance = builder.defineInRange("renderRadarDistance", 256.0, 0.0, 1000.0);
            this.renderOtherExternalPartDistance = builder.defineInRange("renderOtherExternalPartDistance", 192.0, 0.0, 1000.0);
            builder.pop();
            builder.push("helicopter-input");
            this.enableHeliInputSmoothing = builder.comment("Enable helicopter-specific input smoothing for pitch/roll/yaw.").define("enableHeliInputSmoothing", true);
            this.heliPitchSmoothingStep = builder.comment("Per-tick approach step for heli pitch input smoothing. Smaller = smoother (0-1).").defineInRange("heliPitchSmoothingStep", 0.06, 0.0, 1.0);
            this.heliRollSmoothingStep = builder.comment("Per-tick approach step for heli roll input smoothing. Smaller = smoother (0-1).").defineInRange("heliRollSmoothingStep", 0.06, 0.0, 1.0);
            this.heliYawSmoothingStep = builder.comment("Per-tick approach step for heli yaw input smoothing. Smaller = smoother (0-1).").defineInRange("heliYawSmoothingStep", 0.04, 0.0, 1.0);
            builder.pop();
            builder.push("hud");
            this.enableModernHUD = builder.comment("Enable the modern, consolidated vehicle HUD.").define("enableModernHUD", false);
            this.modernHudOpacity = builder.comment("Opacity of the modern HUD panels (0.0-1.0).").defineInRange("modernHudOpacity", 0.85, 0.0, 1.0);
            this.modernHudScale = builder.comment("Scale of the modern HUD panels (0.5-1.5).").defineInRange("modernHudScale", 1.0, 0.5, 1.5);
            this.hudSpeedUnit = builder.comment("Speed units: mps (m/s), kph (km/h), knots (kt)").define("hudSpeedUnit", (Object)"mps");
            this.hudAltUnit = builder.comment("Altitude units: m (meters), ft (feet)").define("hudAltUnit", (Object)"m");
            this.showControlsInModernHUD = builder.comment("If true, keeps the stick/rudder control overlay visible when Modern HUD is enabled.").define("showControlsInModernHUD", false);
            builder.pop();
            builder.pop();
        }

        public Vec3 getTargetPos() {
            return new Vec3(((Double)this.targetPosX.get()).doubleValue(), ((Double)this.targetPosY.get()).doubleValue(), ((Double)this.targetPosZ.get()).doubleValue());
        }
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue maxBlockCheckDepth;
        public final ForgeConfigSpec.BooleanValue logTurretAIDebug;
        public final ForgeConfigSpec.DoubleValue gasCanXpRepairRate;
        public final ForgeConfigSpec.DoubleValue recoverPartWeight;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> radarMobs;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("performance");
            this.maxBlockCheckDepth = builder.comment("The number of blocks between 2 entities to check if they can see eachother.").defineInRange("maxBlockCheckDepth", 256, 10, 400);
            builder.pop();
            builder.push("debug");
            this.logTurretAIDebug = builder.define("logTurretAIDebug", false);
            builder.pop();
            builder.push("gameplay");
            this.gasCanXpRepairRate = builder.comment("The average durability repaired by mending per xp point.").defineInRange("gasCanXpRepairRate", 2.0, 2.0, 1000.0);
            this.recoverPartWeight = builder.comment("Roughly the randomly weighted percentage of vehicle recipe items recovered from crash site.").defineInRange("recoverPartWeight", 0.7, 0.0, 1.0);
            this.radarMobs = builder.defineList("radarMobs", List.of("net.minecraft.world.entity.Mob"), entry -> UtilEntity.getEntityClass((String)((String)entry)) != null);
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.DoubleValue universalIRLScale;
        public final ForgeConfigSpec.DoubleValue universalTopSpeed;
        public final ForgeConfigSpec.DoubleValue vehicleSpeedFactor;
        public final ForgeConfigSpec.DoubleValue planeSpeedFactor;
        public final ForgeConfigSpec.DoubleValue heliSpeedFactor;
        public final ForgeConfigSpec.DoubleValue carSpeedFactor;
        public final ForgeConfigSpec.DoubleValue boatSpeedFactor;
        public final ForgeConfigSpec.DoubleValue heliLateralDampingXZ;
        public final ForgeConfigSpec.DoubleValue heliHoverDamping;
        public final ForgeConfigSpec.BooleanValue enableGroundEffect;
        public final ForgeConfigSpec.DoubleValue groundEffectStrength;
        public final ForgeConfigSpec.DoubleValue groundEffectMaxHeight;
        public final ForgeConfigSpec.BooleanValue enableTranslationalLift;
        public final ForgeConfigSpec.DoubleValue translationalLiftMaxBonus;
        public final ForgeConfigSpec.DoubleValue translationalLiftFullSpeed;
        public final ForgeConfigSpec.BooleanValue enableVRS;
        public final ForgeConfigSpec.DoubleValue vrsDescentTrigger;
        public final ForgeConfigSpec.DoubleValue vrsHorizMaxSpeed;
        public final ForgeConfigSpec.DoubleValue vrsMaxPenalty;
        public final ForgeConfigSpec.BooleanValue enableAntiTorque;
        public final ForgeConfigSpec.DoubleValue antiTorqueCoeff;
        public final ForgeConfigSpec.DoubleValue antiTorqueDirection;
        public final ForgeConfigSpec.DoubleValue yawDamperGain;
        public final ForgeConfigSpec.DoubleValue rotorSpoolUpRate;
        public final ForgeConfigSpec.DoubleValue rotorSpoolDownRate;
        public final ForgeConfigSpec.DoubleValue minControlAuthorityAtIdle;
        public final ForgeConfigSpec.DoubleValue igeExtraLateralDamping;
        public final ForgeConfigSpec.DoubleValue igeDampingMaxHeight;
        public final ForgeConfigSpec.BooleanValue enableETLPitchUp;
        public final ForgeConfigSpec.DoubleValue etlPitchGain;
        public final ForgeConfigSpec.BooleanValue enableTailRotorRollCoupling;
        public final ForgeConfigSpec.DoubleValue tailRotorRollCoeff;
        public final ForgeConfigSpec.BooleanValue scaleAuthorityPreClamp;
        public final ForgeConfigSpec.BooleanValue enableETLTrimAssist;
        public final ForgeConfigSpec.DoubleValue etlTrimGain;
        public final ForgeConfigSpec.BooleanValue scaleTorqueWithRotorPower;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("speed_factors");
            this.universalIRLScale = builder.comment("The percent of the IRL top speed vehicle's travel at. 1/8th (0.125) by default.").defineInRange("universalIRLScale", 0.125, 0.01, 1.0);
            this.universalTopSpeed = builder.comment(new String[]{"The absolute max horizontal speed for all vehicles in blocks/second. ", "Lower this value if your playing on a server that doesn't have pre-generated chunks."}).defineInRange("universalTopSpeed", 200.0, 1.0, 1000.0);
            this.vehicleSpeedFactor = builder.defineInRange("vehicleSpeedFactor", 1.0, 0.0, 10.0);
            this.planeSpeedFactor = builder.defineInRange("planeSpeedFactor", 1.0, 0.0, 10.0);
            this.heliSpeedFactor = builder.defineInRange("heliSpeedFactor", 1.0, 0.0, 10.0);
            this.carSpeedFactor = builder.defineInRange("carSpeedFactor", 1.0, 0.0, 10.0);
            this.boatSpeedFactor = builder.defineInRange("boatSpeedFactor", 1.0, 0.0, 10.0);
            builder.pop();
            builder.push("helicopter_handling");
            this.heliLateralDampingXZ = builder.comment("Per-tick lateral damping multiplier for helicopters while airborne and not in hover assist. 1 = no damping.").defineInRange("heliLateralDampingXZ", 0.99, 0.9, 1.0);
            this.heliHoverDamping = builder.comment("Per-tick velocity damping multiplier applied in heli hover assist mode (all axes). 1 = no damping.").defineInRange("heliHoverDamping", 0.95, 0.8, 1.0);
            builder.pop();
            builder.push("helicopter_physics");
            this.enableGroundEffect = builder.comment("Enable ground effect: increased lift near ground (IGE).").define("enableGroundEffect", true);
            this.groundEffectStrength = builder.comment("Max additional lift near ground (as a fraction). 0.2 = up to +20%.").defineInRange("groundEffectStrength", 0.2, 0.0, 1.0);
            this.groundEffectMaxHeight = builder.comment("Height above ground (blocks) where ground effect fades to zero.").defineInRange("groundEffectMaxHeight", 5.0, 0.0, 64.0);
            this.enableTranslationalLift = builder.comment("Enable ETL: increased lift with forward airspeed up to a limit.").define("enableTranslationalLift", true);
            this.translationalLiftMaxBonus = builder.comment("Max additional lift at or above ETL full speed (fraction). 0.15 = +15%.").defineInRange("translationalLiftMaxBonus", 0.15, 0.0, 1.0);
            this.translationalLiftFullSpeed = builder.comment("Horizontal speed (blocks/tick) where ETL bonus reaches max.").defineInRange("translationalLiftFullSpeed", 0.35, 0.0, 5.0);
            this.enableVRS = builder.comment("Enable VRS: lift degradation during high-rate vertical descents with low forward speed.").define("enableVRS", true);
            this.vrsDescentTrigger = builder.comment("Downward speed (blocks/tick) above which VRS begins.").defineInRange("vrsDescentTrigger", 0.15, 0.0, 5.0);
            this.vrsHorizMaxSpeed = builder.comment("Max horizontal speed (blocks/tick) for VRS to apply (above this, no VRS).").defineInRange("vrsHorizMaxSpeed", 0.2, 0.0, 5.0);
            this.vrsMaxPenalty = builder.comment("Max lift reduction from VRS (fraction). 0.5 = up to -50% lift.").defineInRange("vrsMaxPenalty", 0.5, 0.0, 1.0);
            this.enableAntiTorque = builder.comment("Enable anti-torque/yaw coupling: simulates main rotor torque and tail rotor compensation.").define("enableAntiTorque", true);
            this.antiTorqueCoeff = builder.comment("Yaw moment per unit rotor thrust (tune small).").defineInRange("antiTorqueCoeff", 0.0025, 0.0, 1.0);
            this.antiTorqueDirection = builder.comment("Direction sign of main rotor torque (+1 or -1). Use to flip depending on rotor spin.").defineInRange("antiTorqueDirection", 1.0, -1.0, 1.0);
            this.yawDamperGain = builder.comment("Additional yaw rate damping gain to stabilize heading (applied as moment proportional to yaw rate).").defineInRange("yawDamperGain", 0.02, 0.0, 1.0);
            this.rotorSpoolUpRate = builder.comment("Per-tick rotor power increase step towards throttle command.").defineInRange("rotorSpoolUpRate", 0.02, 0.0, 1.0);
            this.rotorSpoolDownRate = builder.comment("Per-tick rotor power decrease step towards throttle command.").defineInRange("rotorSpoolDownRate", 0.04, 0.0, 1.0);
            this.minControlAuthorityAtIdle = builder.comment("Minimum fraction of control authority (pitch/roll/yaw) when rotor power is near zero.").defineInRange("minControlAuthorityAtIdle", 0.3, 0.0, 1.0);
            this.igeExtraLateralDamping = builder.comment("Additional lateral damping multiplier applied near ground (IGE). 0 = none; 0.03 ~ mild.").defineInRange("igeExtraLateralDamping", 0.0, 0.0, 0.2);
            this.igeDampingMaxHeight = builder.comment("Max height above ground (blocks) over which extra IGE lateral damping fades.").defineInRange("igeDampingMaxHeight", 3.0, 0.0, 16.0);
            this.enableETLPitchUp = builder.comment("Enable ETL-induced pitch-up moment that grows with forward speed.").define("enableETLPitchUp", true);
            this.etlPitchGain = builder.comment("Pitch-up moment gain vs normalized forward speed (tune small, e.g., 0.02).").defineInRange("etlPitchGain", 0.02, 0.0, 0.2);
            this.enableTailRotorRollCoupling = builder.comment("Enable roll moment proportional to anti-torque (tail rotor) thrust.").define("enableTailRotorRollCoupling", true);
            this.tailRotorRollCoeff = builder.comment("Roll moment per unit of anti-torque yaw moment (tune small, e.g., 0.15).").defineInRange("tailRotorRollCoeff", 0.15, 0.0, 1.0);
            this.scaleAuthorityPreClamp = builder.comment("Scale control max deltas by rotor power (pre-clamp). If false, authority scales after clamping.").define("scaleAuthorityPreClamp", true);
            this.enableETLTrimAssist = builder.comment("Apply small auto pitch-down with forward speed to reduce manual trim.").define("enableETLTrimAssist", true);
            this.etlTrimGain = builder.comment("Pitch-down trim gain vs normalized forward speed (tune very small, e.g., 0.01).").defineInRange("etlTrimGain", 0.01, 0.0, 0.1);
            this.scaleTorqueWithRotorPower = builder.comment("Scale applied control torques by rotor power (alternative to control moment scaling).").define("scaleTorqueWithRotorPower", false);
            builder.pop();
        }
    }
}

