/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mrcrayfish.framework.api.registry.BlockRegistryEntry;
import com.mrcrayfish.framework.api.registry.CustomStatRegistryEntry;
import com.mrcrayfish.framework.api.registry.IRegisterFunction;
import com.mrcrayfish.framework.platform.Services;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.function.TriFunction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class RegistryEntry<T> {
    protected final Registry<?> registry;
    protected final ResourceLocation id;
    protected final Supplier<T> supplier;
    private T instance;

    RegistryEntry(Registry<?> registry, ResourceLocation id, Supplier<T> supplier) {
        this.registry = registry;
        this.id = id;
        this.supplier = supplier;
    }

    public T get() {
        if (this.instance == null) {
            throw new IllegalStateException("Entry has not been created yet");
        }
        return this.instance;
    }

    protected T create() {
        if (this.instance != null) {
            throw new IllegalStateException("Entry has already been created");
        }
        this.instance = this.supplier.get();
        return this.instance;
    }

    public Registry<?> getRegistry() {
        return this.registry;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    protected void invalidate() {
        this.instance = null;
    }

    public void register(IRegisterFunction function) {
        function.call(this.registry, this.id, () -> {
            this.invalidate();
            return this.create();
        });
    }

    public static <T extends Attribute> RegistryEntry<T> attribute(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>(Registry.f_122866_, id, supplier);
    }

    public static <T extends Block> RegistryEntry<T> block(ResourceLocation id, Supplier<T> supplier) {
        return new BlockRegistryEntry<Block, BlockItem>((Registry<?>)Registry.f_122824_, id, (Supplier<Block>)supplier, t -> null);
    }

    public static <T extends Block, E extends BlockItem> RegistryEntry<T> blockWithItem(ResourceLocation id, Supplier<T> supplier) {
        return new BlockRegistryEntry<Block, BlockItem>((Registry<?>)Registry.f_122824_, id, (Supplier<Block>)supplier, t -> new BlockItem(t, new Item.Properties()));
    }

    public static <T extends Block, E extends BlockItem> RegistryEntry<T> blockWithItem(ResourceLocation id, Supplier<T> supplier, Function<T, E> function) {
        return new BlockRegistryEntry<T, E>((Registry<?>)Registry.f_122824_, id, supplier, function);
    }

    public static <T extends BlockEntity> RegistryEntry<BlockEntityType<T>> blockEntity(ResourceLocation id, BiFunction<BlockPos, BlockState, T> function, Supplier<Block[]> validBlocksSupplier) {
        return new RegistryEntry<BlockEntityType<T>>(Registry.f_122830_, id, () -> Services.REGISTRATION.createBlockEntityType(function, validBlocksSupplier));
    }

    public static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>, I extends ArgumentTypeInfo<A, T>> RegistryEntry<I> commandArgumentType(ResourceLocation id, Class<A> argumentTypeClass, Supplier<I> supplier) {
        return new RegistryEntry<ArgumentTypeInfo>(Registry.f_235729_, id, () -> Services.REGISTRATION.createArgumentTypeInfo(argumentTypeClass, supplier));
    }

    public static RegistryEntry<ResourceLocation> customStat(ResourceLocation id, StatFormatter formatter) {
        return new CustomStatRegistryEntry(Registry.f_122832_, id, formatter);
    }

    public static <T extends Enchantment> RegistryEntry<T> enchantment(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>(Registry.f_122825_, id, supplier);
    }

    public static <T extends EntityType<?>> RegistryEntry<T> entityType(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>((Registry<?>)Registry.f_122826_, id, supplier);
    }

    public static <T extends Fluid> RegistryEntry<T> fluid(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>((Registry<?>)Registry.f_122822_, id, supplier);
    }

    public static RegistryEntry<GameEvent> gameEvent(ResourceLocation id) {
        return new RegistryEntry<GameEvent>((Registry<?>)Registry.f_175412_, id, () -> new GameEvent(id.m_135815_(), 16));
    }

    public static RegistryEntry<GameEvent> gameEvent(ResourceLocation id, int notifyRadius) {
        return new RegistryEntry<GameEvent>((Registry<?>)Registry.f_175412_, id, () -> new GameEvent(id.m_135815_(), notifyRadius));
    }

    public static <T extends Item> RegistryEntry<T> item(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>((Registry<?>)Registry.f_122827_, id, supplier);
    }

    public static <T extends AbstractContainerMenu> RegistryEntry<MenuType<T>> menuType(ResourceLocation id, BiFunction<Integer, Inventory, T> function) {
        return new RegistryEntry<MenuType<T>>(Registry.f_122863_, id, () -> Services.REGISTRATION.createMenuType(function));
    }

    public static <T extends AbstractContainerMenu> RegistryEntry<MenuType<T>> menuTypeWithData(ResourceLocation id, TriFunction<Integer, Inventory, FriendlyByteBuf, T> function) {
        return new RegistryEntry<MenuType<T>>(Registry.f_122863_, id, () -> Services.REGISTRATION.createMenuTypeWithData(function));
    }

    public static <T extends MobEffect> RegistryEntry<T> mobEffect(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>(Registry.f_122823_, id, supplier);
    }

    public static <T extends ParticleType<?>> RegistryEntry<T> particleType(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>(Registry.f_122829_, id, supplier);
    }

    public static <T extends Potion> RegistryEntry<T> potion(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>((Registry<?>)Registry.f_122828_, id, supplier);
    }

    public static <T extends RecipeType<?>> RegistryEntry<T> recipeType(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>(Registry.f_122864_, id, supplier);
    }

    public static <T extends Recipe<?>> RegistryEntry<RecipeType<T>> recipeType(final ResourceLocation id) {
        return new RegistryEntry<RecipeType<T>>(Registry.f_122864_, id, () -> new RecipeType<T>(){

            public String toString() {
                return id.m_135815_();
            }
        });
    }

    public static <T extends RecipeSerializer<?>> RegistryEntry<T> recipeSerializer(ResourceLocation id, Supplier<T> supplier) {
        return new RegistryEntry<T>(Registry.f_122865_, id, supplier);
    }

    public static <T extends SoundEvent> RegistryEntry<T> soundEvent(ResourceLocation id, Function<ResourceLocation, Supplier<T>> supplier) {
        return new RegistryEntry<T>(Registry.f_122821_, id, supplier.apply(id));
    }
}

