/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.utils;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;

public class TextureUtils {
    private static final ResourceLocation TEXTURE_STEVE = new ResourceLocation("textures/entity/steve.png");
    private static final ResourceLocation TEXTURE_ALEX = new ResourceLocation("textures/entity/alex.png");
    private static final Map<UUID, SkinType> SKIN_TYPE_CACHE = new Object2ObjectOpenHashMap();

    public static SkinType getPlayerSkinType(@Nullable GameProfile profile) {
        SkinType type = SkinType.DEFAULT;
        if (profile != null && profile.isComplete()) {
            if (SKIN_TYPE_CACHE.containsKey(profile.getId())) {
                type = SKIN_TYPE_CACHE.get(profile.getId());
            } else {
                Minecraft mc = Minecraft.m_91087_();
                Map map = mc.m_91109_().m_118815_(profile);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    String stringType = ((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model");
                    type = TextureUtils.getType(stringType);
                    SKIN_TYPE_CACHE.put(profile.getId(), type);
                } else {
                    type = TextureUtils.getType(DefaultPlayerSkin.m_118629_((UUID)profile.getId()));
                }
            }
        }
        return type;
    }

    private static SkinType getType(@Nullable String stringType) {
        return "slim".equals(stringType) ? SkinType.SLIM : SkinType.DEFAULT;
    }

    public static ResourceLocation getPlayerSkin(PlayerMobEntity entity) {
        return TextureUtils.getTexture(entity, MinecraftProfileTexture.Type.SKIN).orElse(TEXTURE_STEVE);
    }

    public static Optional<ResourceLocation> getPlayerCape(PlayerMobEntity entity) {
        return TextureUtils.getTexture(entity, MinecraftProfileTexture.Type.CAPE);
    }

    private static Optional<ResourceLocation> getTexture(PlayerMobEntity entity, MinecraftProfileTexture.Type type) {
        Minecraft mc;
        Map map;
        if (entity.isTextureAvailable(type)) {
            return Optional.of(entity.getTexture(type));
        }
        GameProfile profile = entity.getProfile();
        if (profile != null && !profile.isComplete()) {
            return TextureUtils.getDefault(profile, type);
        }
        if (profile != null && profile.getName() != null && (map = (mc = Minecraft.m_91087_()).m_91109_().m_118815_(profile)).containsKey(type)) {
            MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)map.get(type);
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)profileTexture.getHash()).toString();
            ResourceLocation location = new ResourceLocation("skins/" + s);
            if (mc.f_90987_.m_174786_(location, (AbstractTexture)MissingTextureAtlasSprite.m_118080_()) != MissingTextureAtlasSprite.m_118080_()) {
                return Optional.of(location);
            }
            RenderSystem.m_69879_(() -> mc.m_91109_().m_118828_(profileTexture, type, entity.getSkinCallback()));
        }
        return TextureUtils.getDefault(profile, type);
    }

    private static Optional<ResourceLocation> getDefault(@Nullable GameProfile profile, MinecraftProfileTexture.Type type) {
        if (type == MinecraftProfileTexture.Type.CAPE || type == MinecraftProfileTexture.Type.ELYTRA) {
            return Optional.empty();
        }
        return Optional.of(TextureUtils.getPlayerSkinType(profile) == SkinType.SLIM ? TEXTURE_ALEX : TEXTURE_STEVE);
    }

    public static enum SkinType {
        DEFAULT,
        SLIM;

    }
}

