/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.sound;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.fml.LogicalSide;
import se.gory_moon.player_mobs.repack.registrate.AbstractRegistrate;
import se.gory_moon.player_mobs.repack.registrate.providers.RegistrateProvider;
import se.gory_moon.player_mobs.utils.CustomRegistrate;

public class SoundProvider
extends SoundDefinitionsProvider
implements RegistrateProvider {
    private final AbstractRegistrate<?> owner;

    public SoundProvider(AbstractRegistrate<?> owner, DataGenerator generator, ExistingFileHelper helper) {
        super(generator, owner.getModid(), helper);
        this.owner = owner;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.CLIENT;
    }

    public void registerSounds() {
        this.owner.genData(CustomRegistrate.SOUND, this);
    }

    public SoundDefinition.Sound createMcSound(String name) {
        return SoundDefinitionsProvider.sound((String)name);
    }

    public SoundDefinition.Sound createSound(String name) {
        return SoundDefinitionsProvider.sound((ResourceLocation)new ResourceLocation(this.owner.getModid(), name));
    }

    protected SoundDefinition subtitle(String subtitle) {
        return SoundDefinitionsProvider.definition().subtitle(subtitle);
    }

    public SoundDefinition noSubtitle() {
        return SoundDefinitionsProvider.definition();
    }

    protected void add(ResourceLocation soundEvent, SoundDefinition definition) {
        super.add(soundEvent, definition);
    }

    protected void add(String soundEvent, SoundDefinition definition) {
        super.add(soundEvent, definition);
    }
}

