/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import se.gory_moon.player_mobs.LangKeys;
import se.gory_moon.player_mobs.entity.EntityRegistry;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;
import se.gory_moon.player_mobs.utils.NameManager;

public class PlayerMobsCommand {
    private static final SimpleCommandExceptionType SUMMON_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)LangKeys.COMMANDS_SPAWN_FAILED.key()));
    private static final SimpleCommandExceptionType DUPLICATE_UUID = new SimpleCommandExceptionType((Message)Component.m_237115_((String)LangKeys.COMMANDS_SPAWN_UUID.key()));
    private static final SimpleCommandExceptionType INVALID_POS = new SimpleCommandExceptionType((Message)Component.m_237115_((String)LangKeys.COMMANDS_SPAWN_INVALID_POS.key()));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playermobs").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(context -> {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)LangKeys.COMMANDS_RELOAD_START.key()), true);
            NameManager.INSTANCE.reloadRemoteLinks().thenAccept(change -> ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)LangKeys.COMMANDS_RELOAD_DONE.key(), (Object[])new Object[]{change}), true));
            return 1;
        }))).then(Commands.m_82127_((String)"spawn").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"username", (ArgumentType)StringArgumentType.string()).executes(context -> PlayerMobsCommand.spawnPlayerMob((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"username"), ((CommandSourceStack)context.getSource()).m_81371_()))).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> PlayerMobsCommand.spawnPlayerMob((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"username"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos")))))));
    }

    private static int spawnPlayerMob(CommandSourceStack source, String username, Vec3 pos) throws CommandSyntaxException {
        BlockPos blockpos = new BlockPos(pos);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POS.create();
        }
        PlayerMobEntity entity = EntityRegistry.PLAYER_MOB_ENTITY.create((Level)source.m_81372_());
        if (entity == null) {
            throw SUMMON_FAILED.create();
        }
        entity.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, entity.m_146908_(), entity.m_146909_());
        entity.setUsername(username);
        entity.m_6518_((ServerLevelAccessor)source.m_81372_(), source.m_81372_().m_6436_(entity.m_20183_()), MobSpawnType.COMMAND, null, null);
        if (!source.m_81372_().m_8860_((Entity)entity)) {
            throw DUPLICATE_UUID.create();
        }
        source.m_81354_((Component)Component.m_237110_((String)LangKeys.COMMANDS_SPAWN_SUCCESS.key(), (Object[])new Object[]{entity.m_5446_()}), true);
        return 1;
    }
}

