/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import se.gory_moon.player_mobs.utils.ItemManager;
import se.gory_moon.player_mobs.utils.NameManager;
import se.gory_moon.player_mobs.utils.ThreadUtils;

public class Configs {
    public static final Common COMMON;
    public static final ForgeConfigSpec commonSpec;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)pair.getRight();
        COMMON = (Common)pair.getKey();
    }

    public static class Common {
        public ForgeConfigSpec.BooleanValue attackTwin;
        public ForgeConfigSpec.BooleanValue openDoors;
        public ForgeConfigSpec.EnumValue<Difficulty> openDoorsDifficulty;
        public ForgeConfigSpec.DoubleValue pickupItemsChance;
        public ForgeConfigSpec.DoubleValue playerHeadDropChance;
        public ForgeConfigSpec.DoubleValue mobHeadDropChance;
        public ForgeConfigSpec.DoubleValue babySpawnChance;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> dimensionBlocklistStrings;
        public final List<ResourceKey<Level>> dimensionBlocklist = new CopyOnWriteArrayList<ResourceKey<Level>>();
        public ForgeConfigSpec.ConfigValue<List<? extends String>> mainItems;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> offhandItems;
        public ForgeConfigSpec.EnumValue<Difficulty> offhandDifficultyLimit;
        public ForgeConfigSpec.DoubleValue offhandSpawnChance;
        public ForgeConfigSpec.BooleanValue allowTippedArrows;
        public ForgeConfigSpec.BooleanValue forceSpawnItem;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> tippedArrowBlocklistStrings;
        public final List<ResourceLocation> tippedArrowBlocklist = new CopyOnWriteArrayList<ResourceLocation>();
        public ForgeConfigSpec.ConfigValue<List<? extends String>> mobNames;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> nameLinks;
        public ForgeConfigSpec.IntValue nameLinksSyncTime;
        public ForgeConfigSpec.BooleanValue useWhitelist;
        private static final List<String> DEFAULT_MAIN_HAND_ITEMS = ImmutableList.of((Object)"minecraft:bow-90", (Object)"minecraft:crossbow-10", (Object)"minecraft:stone_sword-64", (Object)"minecraft:iron_sword-20", (Object)"minecraft:golden_sword-10", (Object)"minecraft:diamond_sword-5", (Object)"minecraft:netherite_sword-1");
        private static final List<String> DEFAULT_OFFHAND_ITEMS = ImmutableList.of((Object)"minecraft:shield-1", (Object)"minecraft:air-4");
        private static final List<String> DEFAULT_BLOCKED_POTIONS = ImmutableList.of((Object)"minecraft:awkward", (Object)"minecraft:empty", (Object)"minecraft:fire_resistance", (Object)"minecraft:healing", (Object)"minecraft:invisibility", (Object)"minecraft:leaping", (Object)"minecraft:long_fire_resistance", (Object)"minecraft:long_invisibility", (Object)"minecraft:long_leaping", (Object)"minecraft:long_night_vision", (Object)"minecraft:long_regeneration", (Object)"minecraft:long_strength", (Object[])new String[]{"minecraft:long_swiftness", "minecraft:long_turtle_master", "minecraft:long_water_breathing", "minecraft:luck", "minecraft:mundane", "minecraft:night_vision", "minecraft:regeneration", "minecraft:strength", "minecraft:strong_healing", "minecraft:strong_leaping", "minecraft:strong_regeneration", "minecraft:strong_strength", "minecraft:strong_swiftness", "minecraft:strong_turtle_master", "minecraft:swiftness", "minecraft:thick", "minecraft:turtle_master", "minecraft:water", "minecraft:water_breathing"});
        private static final List<String> DEFAULT_NAMES = ImmutableList.of((Object)"Gory_Moon", (Object)"Darkosto", (Object)"016Nojr", (Object)"BluSunrize", (Object)"Buuz135", (Object)"Darkere", (Object)"Darkhax", (Object)"Drullkus", (Object)"Ellpeck", (Object)"Emberwalker", (Object)"Gigabit101", (Object)"Kamefrede", (Object[])new String[]{"KnightMiner_", "Lat", "LexManos", "Mrbysco", "P3pp3rF1y", "Ray", "Ridanis", "SOTMead", "ShyNieke", "SkySom", "Soaryn", "TamasHenning", "ValkyrieofNight", "XCompWiz", "cpw11", "darkphan", "direwolf20", "dmodoomsirius", "dmodoomsirius", "malte0811", "nekosune", "neptunepink", "vadis365", "wyld", "paulsoaresjr", "Mhykol", "Vswe", "TurkeyDev", "Gen_Deathrow", "Sevadus", "jeb_", "Dinnerbone", "Grumm", "fry_"});

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.attackTwin = builder.comment(new String[]{"If true the player mobs will attack all players", "If false they will ignore players with the same name as themself"}).define("Attack Twin", true);
            this.openDoors = builder.comment("If the player mobs should be able to open doors.").define("Open Doors", true);
            this.openDoorsDifficulty = builder.comment("The difficulty and above that player mobs can open doors, if enabled above.").defineEnum("Open Doors Difficulty", (Enum)Difficulty.HARD);
            this.pickupItemsChance = builder.comment(new String[]{"The chance of the mob getting the ability to pickup items, it's used on mob spawn.", "Set to -1 to disable."}).defineInRange("Pickup Item Chance", 0.55, -1.0, 256.0);
            this.playerHeadDropChance = builder.comment(new String[]{"The chance of players dropping a head with their texture.", "Set to -1 to disable."}).defineInRange("Player Head Drop Chance", 1.0, -1.0, 1.0);
            this.mobHeadDropChance = builder.comment(new String[]{"The chance of player mobs dropping their head.", "Set to -1 to disable."}).defineInRange("Mob Head Drop Chance", 0.25, -1.0, 1.0);
            builder.pop().comment("Configs related to spawning the mobs").push("spawning");
            this.babySpawnChance = builder.comment(new String[]{"Chance that a player mob will spawn as a baby.", "Set to -1 to disable."}).defineInRange("Baby Spawn Chance", 0.1, -1.0, 1.0);
            this.dimensionBlocklistStrings = builder.comment(new String[]{"The id of the dimensions to block spawning in.", "The player mobs spawn where Zombies spawn, so no need to block dimensions that doesn't contain Zombies.", "Example id: \"minecraft:overworld\""}).defineList("Dimension Blocklist", (List)ImmutableList.of(), Common::validResourceLocation);
            this.forceSpawnItem = builder.comment("Force the mobs to spawn holding items.").define("Force Items Spawn", false);
            this.mainItems = builder.comment(new String[]{"A list of items that the player mobs can spawn with.", "Default is 40% for a bow, 10% for a crossbow and 50% for a sword, then the swords are distributed after that.", "There is a separated chance to spawn with an item at all, this is to pick what to spawn when it does", "Syntax is \"namespace:id-weight\""}).defineList("Spawn Items", DEFAULT_MAIN_HAND_ITEMS, Common::validString);
            this.offhandItems = builder.comment(new String[]{"What item to be able to spawn in the offhand", "Offhand items can only spawn when on hard difficulty", "It won't spawn an item in the offhand if it spawns with a bow like item.", "There is a separated chance to spawn with an item at all, this is to pick what it to spawn when it does", "Syntax is \"namespace:id-weight\""}).defineList("Spawn Items Offhand", DEFAULT_OFFHAND_ITEMS, Common::validString);
            this.offhandDifficultyLimit = builder.comment("The difficulty and above that player mobs can spawn with items in their offhand.").defineEnum("Offhand Spawn Difficulty", (Enum)Difficulty.HARD);
            this.offhandSpawnChance = builder.comment(new String[]{"The chance of items spawning in the offhand", "If holding a projectile weapon this can spawn a tipped arrow if allowed", "Else it will spawn from the offhand item list", "Set to -1 to disable."}).defineInRange("Offhand Spawn Chance", 0.5, -1.0, 1.0);
            this.allowTippedArrows = builder.comment("Allow for a change to spawn a random tipped arrow when the mob is holding a projectile weapon").define("Spawn Tipped Arrows", true);
            this.tippedArrowBlocklistStrings = builder.comment("A list of potion \"namespace:id\" to block from getting applied to tipped arrows").defineList("Tipped Arrow Blocklist", DEFAULT_BLOCKED_POTIONS, Common::validResourceLocation);
            builder.pop().comment("Configs related to the names of the mobs.").push("names");
            this.nameLinks = builder.comment(new String[]{"A list of links to get names that the player mobs can have.", "The names need to be separated by a newline.", "Names from these links are combined with the named from below", "As an example you have Twitch subs in the game by using https://whitelist.gorymoon.se"}).defineList("Name Links", (List)ImmutableList.of(), Common::validString);
            this.nameLinksSyncTime = builder.comment(new String[]{"The time interval in minutes when to reload the links (approximately, based on TPS)", "If set to 0 it will only sync once on load."}).defineInRange("Reload Interval", 60, 0, Integer.MAX_VALUE);
            this.mobNames = builder.comment("A list of names that the player mobs can have.").defineList("Mob Names", DEFAULT_NAMES, Common::validString);
            this.useWhitelist = builder.comment("If the names in the whitelist should be used for the player mobs.").define("Use Whitelist", true);
            builder.pop();
        }

        private static boolean validString(Object o) {
            return o instanceof String && !StringUtils.isEmpty((CharSequence)((String)o));
        }

        private static boolean validResourceLocation(Object o) {
            return Common.validString(o) && ResourceLocation.m_135820_((String)((String)o)) != null;
        }

        public boolean isDimensionBlocked(ResourceKey<Level> type) {
            return this.dimensionBlocklist.contains(type);
        }

        @SubscribeEvent
        void onLoad(ModConfigEvent.Loading event) {
            this.configReload();
        }

        @SubscribeEvent
        void onReload(ModConfigEvent.Reloading event) {
            this.configReload();
        }

        private void configReload() {
            ThreadUtils.tryRunOnMain(() -> {
                this.dimensionBlocklist.clear();
                this.dimensionBlocklist.addAll(((List)this.dimensionBlocklistStrings.get()).stream().map(ResourceLocation::m_135820_).filter(Objects::nonNull).map(s -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)s)).toList());
                this.tippedArrowBlocklist.clear();
                this.tippedArrowBlocklist.addAll(((List)this.tippedArrowBlocklistStrings.get()).stream().map(ResourceLocation::m_135820_).filter(Objects::nonNull).toList());
                NameManager.INSTANCE.configLoad();
                ItemManager.INSTANCE.configLoad();
            });
        }
    }
}

