/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;

public class ResourceUtils {
    public static final List<ResourceLocation> TEXTURE_RESOURCE_LOCATIONS = new ArrayList<ResourceLocation>();
    public static final List<ResourceLocation> SLEEPING_BAG_TEXTURE_RESOURCE_LOCATIONS = new ArrayList<ResourceLocation>();

    public static ResourceLocation getBackpackTexture(Item item) {
        return TEXTURE_RESOURCE_LOCATIONS.get(ModItems.BACKPACKS.indexOf(item));
    }

    public static ResourceLocation getSleepingBagTexture(int colorId) {
        return SLEEPING_BAG_TEXTURE_RESOURCE_LOCATIONS.get(colorId);
    }

    public static ResourceLocation getDefaultSleepingBagTexture() {
        return SLEEPING_BAG_TEXTURE_RESOURCE_LOCATIONS.get(14);
    }

    public static void createTextureLocations() {
        TEXTURE_RESOURCE_LOCATIONS.clear();
        for (String name : Reference.BACKPACK_NAMES) {
            ResourceLocation res = new ResourceLocation("travelersbackpack", "textures/model/" + name.toLowerCase(Locale.ENGLISH) + ".png");
            TEXTURE_RESOURCE_LOCATIONS.add(res);
        }
    }

    public static void createSleepingBagTextureLocations() {
        SLEEPING_BAG_TEXTURE_RESOURCE_LOCATIONS.clear();
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation res = new ResourceLocation("travelersbackpack", "textures/model/bags/" + color.m_41065_().toLowerCase(Locale.ENGLISH) + "_sleeping_bag.png");
            SLEEPING_BAG_TEXTURE_RESOURCE_LOCATIONS.add(res);
        }
    }

    public static ResourceLocation create(String path) {
        return new ResourceLocation("travelersbackpack", path);
    }
}

