/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.model.FluidModelPart;
import com.tiviacz.travelersbackpack.client.model.StackModelPart;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TravelersBackpackWearableModel
extends HumanoidModel {
    public ModelPart mainBody;
    public ModelPart tankLeftTop;
    public ModelPart tankRightTop;
    public ModelPart sleepingBag;
    public ModelPart sleepingBagExtras;
    public ModelPart leftStrap;
    public ModelPart rightStrap;
    public ModelPart top;
    public ModelPart bottom;
    public ModelPart pocketFace;
    public ModelPart tankLeftBottom;
    public ModelPart tankLeftWall4;
    public ModelPart tankLeftWall3;
    public ModelPart tankLeftWall2;
    public ModelPart tankLeftWall1;
    public ModelPart tankRightBottom;
    public ModelPart tankRightWall2;
    public ModelPart tankRightWall1;
    public ModelPart tankRightWall3;
    public ModelPart tankRightWall4;
    public ModelPart sleepingBagStrapLeftMid;
    public ModelPart sleepingBagStrapRightBottom;
    public ModelPart sleepingBagStrapLeftBottom;
    public ModelPart sleepingBagStrapRightMid;
    public ModelPart sleepingBagStrapRightTop;
    public ModelPart sleepingBagStrapLeftTop;
    public ModelPart villagerNose;
    public ModelPart wolfNose;
    public ModelPart foxNose;
    public ModelPart ocelotNose;
    public ModelPart pigNose;
    public StackModelPart stacks;
    public FluidModelPart fluids;
    private final LivingEntity livingEntity;
    private final MultiBufferSource buffer;

    public TravelersBackpackWearableModel(LivingEntity livingEntity, MultiBufferSource buffer, ModelPart rootPart) {
        super(rootPart);
        this.livingEntity = livingEntity;
        this.buffer = buffer;
        this.mainBody = rootPart.m_171324_("body").m_171324_("main_body");
        this.top = this.mainBody.m_171324_("top");
        this.bottom = this.mainBody.m_171324_("bottom");
        this.pocketFace = this.mainBody.m_171324_("pocketFace");
        this.leftStrap = this.mainBody.m_171324_("leftStrap");
        this.rightStrap = this.mainBody.m_171324_("rightStrap");
        this.tankLeftTop = rootPart.m_171324_("body").m_171324_("tankLeftTop");
        this.tankLeftBottom = this.tankLeftTop.m_171324_("tankLeftBottom");
        this.tankLeftWall1 = this.tankLeftBottom.m_171324_("tankLeftWall1");
        this.tankLeftWall2 = this.tankLeftBottom.m_171324_("tankLeftWall2");
        this.tankLeftWall3 = this.tankLeftBottom.m_171324_("tankLeftWall3");
        this.tankLeftWall4 = this.tankLeftBottom.m_171324_("tankLeftWall4");
        this.tankRightTop = rootPart.m_171324_("body").m_171324_("tankRightTop");
        this.tankRightBottom = this.tankRightTop.m_171324_("tankRightBottom");
        this.tankRightWall1 = this.tankRightBottom.m_171324_("tankRightWall1");
        this.tankRightWall2 = this.tankRightBottom.m_171324_("tankRightWall2");
        this.tankRightWall3 = this.tankRightBottom.m_171324_("tankRightWall3");
        this.tankRightWall4 = this.tankRightBottom.m_171324_("tankRightWall4");
        this.sleepingBag = rootPart.m_171324_("body").m_171324_("sleepingBag");
        this.sleepingBagExtras = rootPart.m_171324_("body").m_171324_("sleepingBagExtras");
        this.sleepingBagStrapLeftTop = this.sleepingBagExtras.m_171324_("sleepingBagStrapLeftTop");
        this.sleepingBagStrapLeftMid = this.sleepingBagExtras.m_171324_("sleepingBagStrapLeftMid");
        this.sleepingBagStrapLeftBottom = this.sleepingBagExtras.m_171324_("sleepingBagStrapLeftBottom");
        this.sleepingBagStrapRightTop = this.sleepingBagExtras.m_171324_("sleepingBagStrapRightTop");
        this.sleepingBagStrapRightMid = this.sleepingBagExtras.m_171324_("sleepingBagStrapRightMid");
        this.sleepingBagStrapRightBottom = this.sleepingBagExtras.m_171324_("sleepingBagStrapRightBottom");
        this.villagerNose = rootPart.m_171324_("body").m_171324_("villagerNose");
        this.ocelotNose = rootPart.m_171324_("body").m_171324_("ocelotNose");
        this.pigNose = rootPart.m_171324_("body").m_171324_("pigNose");
        this.foxNose = rootPart.m_171324_("body").m_171324_("foxNose");
        this.wolfNose = rootPart.m_171324_("body").m_171324_("wolfNose");
        this.stacks = new StackModelPart(rootPart.m_171324_("body").m_171324_("stacks"));
        this.fluids = new FluidModelPart(rootPart.m_171324_("body").m_171324_("fluids"));
    }

    public void setupAngles(PlayerModel model) {
        this.mainBody.m_104315_(model.f_102810_);
        this.sleepingBag.m_104315_(model.f_102810_);
        this.sleepingBagExtras.m_104315_(model.f_102810_);
        this.tankLeftTop.m_104315_(model.f_102810_);
        this.tankRightTop.m_104315_(model.f_102810_);
        this.villagerNose.m_104315_(model.f_102810_);
        this.pigNose.m_104315_(model.f_102810_);
        this.ocelotNose.m_104315_(model.f_102810_);
        this.wolfNose.m_104315_(model.f_102810_);
        this.foxNose.m_104315_(model.f_102810_);
        this.stacks.m_104315_(model.f_102810_);
        this.fluids.m_104315_(model.f_102810_);
    }

    public void setupAngles(HumanoidModel model) {
        this.mainBody.m_104315_(model.f_102810_);
        this.sleepingBag.m_104315_(model.f_102810_);
        this.sleepingBagExtras.m_104315_(model.f_102810_);
        this.tankLeftTop.m_104315_(model.f_102810_);
        this.tankRightTop.m_104315_(model.f_102810_);
        this.villagerNose.m_104315_(model.f_102810_);
        this.pigNose.m_104315_(model.f_102810_);
        this.ocelotNose.m_104315_(model.f_102810_);
        this.wolfNose.m_104315_(model.f_102810_);
        this.foxNose.m_104315_(model.f_102810_);
        this.stacks.m_104315_(model.f_102810_);
        this.fluids.m_104315_(model.f_102810_);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (alpha == 0.25f) {
            this.sleepingBag.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, 1.0f);
        } else {
            LivingEntity livingEntity;
            this.sleepingBag.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.sleepingBagExtras.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.tankLeftTop.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.tankRightTop.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.mainBody.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            if (this.livingEntity != null) {
                ItemStack stack;
                ItemStack itemStack = stack = this.livingEntity instanceof Player ? CapabilityUtils.getWearingBackpack((Player)this.livingEntity) : CapabilityUtils.getWearingBackpack(this.livingEntity);
                if (stack.m_41720_() == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                    this.foxNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
                }
                if (stack.m_41720_() == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                    this.wolfNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
                }
                if (stack.m_41720_() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || stack.m_41720_() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                    this.villagerNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
                }
                if (stack.m_41720_() == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                    this.ocelotNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
                }
                if (stack.m_41720_() == ModItems.PIG_TRAVELERS_BACKPACK.get() || stack.m_41720_() == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                    this.pigNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
                }
            }
            if ((livingEntity = this.livingEntity) instanceof Player) {
                Player player = (Player)livingEntity;
                if (TravelersBackpackConfig.renderTools) {
                    this.stacks.render(poseStack, vertexConsumer, player, this.buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                }
                this.fluids.render(poseStack, vertexConsumer, player, this.buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.f_102809_);
    }
}

