/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.ScrollPaneScreen;
import journeymap.client.ui.component.SelectableParent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class DropDownButton
extends Button
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    private boolean visible = false;
    protected DropDownItem selected;
    protected List<DropDownItem> items;
    protected int paneWidth;
    protected Button.OnPress f_93717_;
    protected Glyph activeGlyph = Glyph.DOWN;
    protected int panelMargin = 2;
    protected ScrollPaneScreen paneScreen;
    protected int buttonBuffer = 50;

    public DropDownButton(String label, Button.OnPress onPress) {
        super(label, DropDownButton.emptyPressable());
        this.f_93717_ = onPress;
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
        this.paneWidth = this.m_5711_();
        this.paneScreen = new ScrollPaneScreen(this, items, this.paneWidth, this.getPaneHeight(), this.getX(), this.getPanelLocation());
    }

    protected void setRenderSolidBackground(boolean value) {
        this.paneScreen.setRenderSolidBackground(value);
    }

    protected void setRenderDecorations(boolean value) {
        this.paneScreen.setRenderDecorations(value);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean buttonClicked = super.m_6375_(mouseX, mouseY, button);
        if (buttonClicked && !this.visible) {
            this.visible = true;
            this.setEnabled(false);
            this.paneScreen.setPaneX(this.getX());
            this.paneScreen.setPaneY(this.getPanelLocation());
            this.paneScreen.display();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        DrawUtil.drawLabel(poseStack, this.visible ? this.activeGlyph.getCode() : Glyph.CLOSED.getCode(), this.getX() + 16, this.getMiddleY() - 1, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, this.visible ? this.disabledLabelColor : this.getLabelColor(), this.visible ? 0.25f : 1.0f, 1.5, false);
    }

    protected int getPanelLocation() {
        Window window = Minecraft.m_91087_().m_91268_();
        int panelHeight = this.getPaneHeight();
        int windowBottom = window.m_85446_();
        if (this.f_93621_ - (this.panelMargin + panelHeight) <= 0) {
            this.activeGlyph = Glyph.DOWN;
            return this.f_93621_ + this.panelMargin + this.f_93619_;
        }
        if (this.f_93621_ + (this.panelMargin + panelHeight) > windowBottom) {
            this.activeGlyph = Glyph.UP;
            return this.f_93621_ - panelHeight - this.panelMargin;
        }
        this.activeGlyph = Glyph.DOWN;
        return this.f_93621_ + this.panelMargin + this.f_93619_;
    }

    protected int getPaneHeight() {
        int size = Math.min(this.items.size(), 6);
        return size * (this.items.get(0).m_93694_() + 5);
    }

    @Override
    public void onRemove() {
        this.visible = false;
        this.setEnabled(true);
    }

    public int m_5711_() {
        int width = 0;
        if (this.items != null) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            for (DropDownItem item : this.items) {
                width = Math.max(width, fontRenderer.m_92895_(this.getLabel(item)));
            }
            this.f_93618_ = width + this.buttonBuffer;
        }
        return this.f_93618_;
    }

    protected String getLabel(DropDownItem item) {
        return item.getLabel();
    }

    @Override
    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.f_93717_.m_93750_((net.minecraft.client.gui.components.Button)selected);
        this.m_93666_((Component)Component.m_237113_((String)selected.getLabel()));
    }

    protected DropDownItem getSelected() {
        return this.selected;
    }

    protected String getSelectedLabel() {
        return this.getLabel(this.selected);
    }

    public static enum Glyph {
        CLOSED("\u25b6"),
        UP("\u25b2"),
        DOWN("\u25bc");

        String code;

        private Glyph(String code) {
            this.code = code;
        }

        String getCode() {
            return this.code;
        }

        public String toString() {
            return this.code;
        }
    }
}

