/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionRegister;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PiglinAi.class})
public abstract class MixinPiglinAi {
    @Inject(at={@At(value="HEAD")}, method={"isNearZombified(Lnet/minecraft/world/entity/monster/piglin/Piglin;)Z"}, cancellable=true)
    private static void isNearZombified(Piglin piglin, CallbackInfoReturnable<Boolean> callback) {
        if (((Boolean)CommonConfigHandler.piglinsHuntZombies.get()).booleanValue()) {
            callback.setReturnValue((Object)false);
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isZombified(Lnet/minecraft/world/entity/EntityType;)Z"}, cancellable=true)
    private static void isZombified(EntityType<?> p_34807_, CallbackInfoReturnable<Boolean> callback) {
        if (((Boolean)CommonConfigHandler.piglinsHuntZombies.get()).booleanValue() && InfectionRegister.canCauseInfection(p_34807_)) {
            callback.setReturnValue((Object)true);
            callback.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"findNearestValidAttackTarget(Lnet/minecraft/world/entity/monster/piglin/Piglin;)Ljava/util/Optional;"}, cancellable=true)
    private static void findNearestValidAttackTarget(Piglin piglin, CallbackInfoReturnable<Optional<? extends LivingEntity>> callback) {
        Brain brain;
        ItemStack stack;
        if (((Boolean)CommonConfigHandler.piglinsHuntZombies.get()).booleanValue() && ((Optional)callback.getReturnValue()).isEmpty() && (stack = piglin.m_21120_(InteractionHand.MAIN_HAND)) != null && stack.m_150930_(Items.f_42717_) && (brain = piglin.m_6274_()).m_21874_(MemoryModuleType.f_26351_)) {
            callback.setReturnValue((Object)brain.m_21952_(MemoryModuleType.f_26351_));
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"admireGoldItem(Lnet/minecraft/world/entity/LivingEntity;)V"}, cancellable=true)
    private static void admireGoldItem(LivingEntity entity, CallbackInfo callback) {
        if (entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && entity.m_21206_().m_204117_(HordesInfection.INFECTION_CURES_TAG)) {
            entity.m_6672_(InteractionHand.OFF_HAND);
            callback.cancel();
        }
    }
}

