/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.CommonUtils;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionConversionEntry;
import net.smileycorp.hordes.common.infection.capability.IInfection;

public class InfectionRegister {
    private static Map<EntityType<?>, InfectionConversionEntry> conversionTable = new HashMap();

    public static void readConfig() {
        InfectionRegister.readEntityConversions();
    }

    private static void readEntityConversions() {
        HordesLogger.logInfo("Trying to read conversion table from config");
        if (CommonConfigHandler.infectionConversionList == null) {
            HordesLogger.logError("Error reading config.", new NullPointerException("Conversion table has loaded as null"));
        } else if (((List)CommonConfigHandler.infectionConversionList.get()).size() <= 0) {
            HordesLogger.logError("Error reading config.", new Exception("Conversion table in config is empty"));
        }
        for (String name : (List)CommonConfigHandler.infectionConversionList.get()) {
            try {
                EntityType type = null;
                int infectChance = 0;
                EntityType result = null;
                CompoundTag nbt = null;
                String[] nameSplit = name.split("-");
                if (nameSplit.length >= 3) {
                    ResourceLocation entity;
                    try {
                        if (nameSplit[0].contains("{")) {
                            nameSplit[0] = nameSplit[0].substring(0, nameSplit[0].indexOf("{"));
                        }
                        if (!ForgeRegistries.ENTITY_TYPES.containsKey(entity = new ResourceLocation(nameSplit[0]))) {
                            throw new Exception("Entity " + entity + " is not registered");
                        }
                        type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entity);
                    }
                    catch (Exception e) {
                        throw new Exception(nameSplit[0] + " is not a resourcelocation");
                    }
                    try {
                        infectChance = Integer.valueOf(nameSplit[1]);
                    }
                    catch (Exception e) {
                        throw new Exception(nameSplit[1] + " is not an integer");
                    }
                    if (nameSplit[2].contains("{")) {
                        String nbtstring = nameSplit[2].substring(nameSplit[2].indexOf("{"));
                        nameSplit[2] = nameSplit[2].substring(0, nameSplit[2].indexOf("{"));
                        nbt = CommonUtils.parseNBT(nameSplit[2], nbtstring);
                    }
                    try {
                        entity = new ResourceLocation(nameSplit[2]);
                        if (!ForgeRegistries.ENTITY_TYPES.containsKey(entity)) {
                            throw new Exception("Entity " + entity + " is not registered");
                        }
                        result = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entity);
                    }
                    catch (Exception e) {
                        throw new Exception(nameSplit[2] + " is not a resourcelocation");
                    }
                }
                if (type == null) {
                    throw new Exception("Entry " + name + " is not in the correct format");
                }
                InfectionConversionEntry entry = new InfectionConversionEntry(infectChance, result);
                if (nbt != null) {
                    entry.setNBT(nbt);
                }
                conversionTable.put(type, entry);
                HordesLogger.logInfo("Loaded conversion " + name + " as " + type + " with infection chance " + infectChance + ", and converts to " + result.toString());
            }
            catch (Exception e) {
                HordesLogger.logError("Error adding conversion " + name + " " + e.getCause() + " " + e.getMessage(), e);
            }
        }
    }

    public static List<ItemStack> getCureList() {
        return ForgeRegistries.ITEMS.tags().getTag(HordesInfection.INFECTION_CURES_TAG).stream().map(item -> new ItemStack((ItemLike)item)).collect(Collectors.toList());
    }

    public static boolean isCure(ItemStack stack) {
        return stack.m_204117_(HordesInfection.INFECTION_CURES_TAG);
    }

    public static boolean canCauseInfection(Entity entity) {
        return entity instanceof Mob && InfectionRegister.canCauseInfection(entity.m_6095_());
    }

    public static boolean canCauseInfection(EntityType<?> entity) {
        return entity.m_204039_(HordesInfection.INFECTION_ENTITIES_TAG);
    }

    public static boolean canBeInfected(Entity entity) {
        if (!(entity instanceof Mob)) {
            return false;
        }
        return conversionTable.containsKey(entity.m_6095_());
    }

    public static void tryToInfect(LivingEntity entity) {
        int c = entity.f_19853_.f_46441_.m_188503_(100);
        if (c <= conversionTable.get(entity.m_6095_()).getInfectChance()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)HordesInfection.INFECTED.get(), InfectionRegister.getInfectionTime(entity), 0));
        }
    }

    public static void convertEntity(Mob entity) {
        conversionTable.get(entity.m_6095_()).convertEntity(entity);
    }

    public static int getInfectionTime(LivingEntity entity) {
        int time = (Integer)CommonConfigHandler.ticksForEffectStage.get();
        LazyOptional optional = entity.getCapability(Hordes.INFECTION);
        if (optional.isPresent()) {
            time = (int)((double)time * Math.pow((Double)CommonConfigHandler.effectStageTickReduction.get(), ((IInfection)optional.resolve().get()).getInfectionCount()));
        }
        return time;
    }
}

