/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.eventbus.api.Event;

public class InfectionConversionEntry {
    protected final int infectChance;
    protected final EntityType<? extends LivingEntity> result;
    protected CompoundTag nbt = null;

    protected InfectionConversionEntry(int infectChance, EntityType<? extends Mob> result) {
        this.infectChance = infectChance;
        this.result = result;
    }

    public LivingEntity convertEntity(Mob entity) {
        LivingConversionEvent.Pre preEvent = new LivingConversionEvent.Pre((LivingEntity)entity, this.result, i -> {});
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        Mob zombie = entity.m_21406_(preEvent.getOutcome(), false);
        if (zombie instanceof AgeableMob) {
            ((AgeableMob)zombie).m_146762_(entity.m_6162_() ? -1000000 : 0);
        }
        if (zombie instanceof Zombie) {
            ((Zombie)zombie).m_6863_(entity.m_6162_());
        }
        if (this.nbt != null) {
            entity.m_7378_(this.nbt);
        }
        LivingConversionEvent.Post postEvent = new LivingConversionEvent.Post((LivingEntity)entity, (LivingEntity)zombie);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        zombie = postEvent.getOutcome();
        return zombie;
    }

    public int getInfectChance() {
        return this.infectChance;
    }

    public void setNBT(CompoundTag nbt) {
        this.nbt = nbt;
    }
}

