/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.data.scripts;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.HordeBuildSpawntableEvent;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.common.hordeevent.data.conditions.Condition;
import net.smileycorp.hordes.common.hordeevent.data.functions.HordeFunction;
import net.smileycorp.hordes.common.hordeevent.data.functions.SetSpawntableFunction;
import net.smileycorp.hordes.common.hordeevent.data.scripts.HordeScriptRegistry;
import net.smileycorp.hordes.common.hordeevent.data.values.ValueGetter;

public class HordeScript<T extends HordePlayerEvent> {
    protected final HordeFunction<T> func;
    protected final Class<T> type;
    private final Condition[] conditions;

    private HordeScript(HordeFunction<T> func, Class<T> type, Condition ... conditions) {
        this.func = func;
        this.type = type;
        this.conditions = conditions;
    }

    public void apply(T event) {
        this.func.apply(event);
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean shouldApply(Level level, Player player, RandomSource rand) {
        for (Condition condition : this.conditions) {
            if (condition.apply(level, player, rand)) continue;
            return false;
        }
        return true;
    }

    public static HordeScript deserialize(ResourceLocation key, JsonElement value) {
        try {
            JsonObject obj = value.getAsJsonObject();
            SetSpawntableFunction function = null;
            ValueGetter getter = ValueGetter.readValue(DataType.STRING, obj.get("value"));
            Class<HordeBuildSpawntableEvent> clazz = null;
            if (obj.get("function").getAsString().equals("hordes:set_spawntable")) {
                function = new SetSpawntableFunction(getter);
                clazz = HordeBuildSpawntableEvent.class;
            }
            ArrayList conditions = Lists.newArrayList();
            for (JsonElement condition : obj.get("conditions").getAsJsonArray()) {
                conditions.add(HordeScriptRegistry.readCondition(condition.getAsJsonObject()));
            }
            if (function == null || clazz == null) {
                throw new Exception("invalid function: " + obj.get("function").getAsString());
            }
            return new HordeScript<HordeBuildSpawntableEvent>(function, clazz, conditions.toArray(new Condition[0]));
        }
        catch (Exception e) {
            HordesLogger.logError("Error loading script " + key + " " + e.getCause() + " " + e.getMessage(), e);
            return null;
        }
    }
}

