/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.data.conditions;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.smileycorp.atlas.api.data.LogicalOperation;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.hordeevent.data.conditions.Condition;
import net.smileycorp.hordes.common.hordeevent.data.scripts.HordeScriptRegistry;

public class LogicalCondition
implements Condition {
    protected final LogicalOperation operation;
    protected final Condition[] conditions;

    private LogicalCondition(LogicalOperation operation, Condition ... conditions) {
        this.operation = operation;
        this.conditions = conditions;
    }

    @Override
    public boolean apply(Level level, Player player, RandomSource rand) {
        boolean result = false;
        for (Condition condition : this.conditions) {
            result = this.operation.apply(result, condition.apply(level, player, rand));
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.conditions.length; ++i) {
            builder.append(this.conditions[i].toString());
            if (i >= this.conditions.length - 1) continue;
            builder.append(" " + this.operation.getSymbol() + " ");
        }
        return super.toString() + "[" + builder.toString() + "]";
    }

    public static LogicalCondition deserialize(LogicalOperation operation, JsonElement json) {
        try {
            ArrayList conditions = Lists.newArrayList();
            for (JsonElement element : json.getAsJsonArray()) {
                try {
                    conditions.add(HordeScriptRegistry.readCondition(element.getAsJsonObject()));
                }
                catch (Exception e) {
                    HordesLogger.logError("Failed to read condition of logical " + element, e);
                }
            }
            return new LogicalCondition(operation, conditions.toArray(new Condition[0]));
        }
        catch (Exception e) {
            HordesLogger.logError("Incorrect parameters for condition hordes:" + operation.getName(), e);
            return null;
        }
    }
}

