/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.hordeevent.HordeSpawnTable;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.data.HordeTableLoader;

public class CommandSpawnWave {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnHordeWave").requires(commandSource -> commandSource.m_6761_(1))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandSpawnWave.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")))).then(Commands.m_82129_((String)"table", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(HordeTableLoader::getSuggestions).executes(ctx -> CommandSpawnWave.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"table")))))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandSpawnWave.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), EntityArgument.m_91477_((CommandContext)ctx, (String)"player")))).then(Commands.m_82129_((String)"table", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(HordeTableLoader::getSuggestions).executes(ctx -> CommandSpawnWave.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), EntityArgument.m_91477_((CommandContext)ctx, (String)"player"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"table"))))));
        dispatcher.register(command);
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int count) throws CommandSyntaxException {
        Player player;
        LazyOptional optional;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.m_81373_() instanceof Player && (optional = (player = (Player)source.m_81373_()).getCapability(Hordes.HORDE_EVENT, null)).isPresent()) {
            ((IHordeEvent)optional.resolve().get()).spawnWave(player, count);
            return 1;
        }
        return 0;
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int count, Collection<ServerPlayer> players) throws CommandSyntaxException {
        for (Player player : players) {
            LazyOptional optional = player.getCapability(Hordes.HORDE_EVENT, null);
            try {
                if (!optional.isPresent()) continue;
                ((IHordeEvent)optional.resolve().get()).spawnWave(player, count);
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to run startHordeEvent command", e);
            }
        }
        return 1;
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int count, ResourceLocation table) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.m_81373_() instanceof Player) {
            return CommandSpawnWave.execute(ctx, count, Lists.newArrayList((Object[])new ServerPlayer[]{source.m_81375_()}), table);
        }
        return 0;
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int count, Collection<ServerPlayer> players, ResourceLocation table) throws CommandSyntaxException {
        for (Player player : players) {
            LazyOptional optional = player.getCapability(Hordes.HORDE_EVENT, null);
            try {
                if (!optional.isPresent()) continue;
                IHordeEvent event = (IHordeEvent)optional.resolve().get();
                HordeSpawnTable current = event.getSpawntable();
                event.setSpawntable(HordeTableLoader.INSTANCE.getTable(table));
                event.spawnWave(player, count);
                event.setSpawntable(current);
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to run startHordeEvent command", e);
            }
        }
        return 1;
    }
}

