/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.capability;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.entity.ai.GoToEntityPositionGoal;
import net.smileycorp.atlas.api.network.SimpleStringMessage;
import net.smileycorp.atlas.api.recipe.WeightedOutputs;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.ai.HordeTrackPlayerGoal;
import net.smileycorp.hordes.common.event.HordeBuildSpawntableEvent;
import net.smileycorp.hordes.common.event.HordeEndEvent;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.common.event.HordeSpawnEntityEvent;
import net.smileycorp.hordes.common.event.HordeStartEvent;
import net.smileycorp.hordes.common.event.HordeStartWaveEvent;
import net.smileycorp.hordes.common.hordeevent.HordeSpawnEntry;
import net.smileycorp.hordes.common.hordeevent.HordeSpawnTable;
import net.smileycorp.hordes.common.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeSpawn;
import net.smileycorp.hordes.common.hordeevent.data.HordeTableLoader;
import net.smileycorp.hordes.common.hordeevent.data.scripts.HordeScript;
import net.smileycorp.hordes.common.hordeevent.data.scripts.HordeScriptLoader;
import net.smileycorp.hordes.common.hordeevent.network.HordeEventPacketHandler;
import net.smileycorp.hordes.common.hordeevent.network.HordeSoundMessage;

class HordeEvent
implements IHordeEvent {
    private Set<Mob> entitiesSpawned = new HashSet<Mob>();
    private int timer = 0;
    private int day = 0;
    private int nextDay = -1;
    private boolean hasChanged = false;
    private Random rand = new Random();
    private HordeSpawnTable loadedTable;

    public HordeEvent() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            HordeSavedData data = HordeSavedData.getData(ServerLifecycleHooks.getCurrentServer().m_129783_());
            this.nextDay = data.getNextDay();
        }
    }

    public void readFromNBT(CompoundTag nbt) {
        this.entitiesSpawned.clear();
        if (nbt.m_128441_("timer")) {
            this.timer = nbt.m_128451_("timer");
        }
        if (nbt.m_128441_("nextDay")) {
            this.nextDay = nbt.m_128451_("nextDay");
        }
        if (nbt.m_128441_("day")) {
            this.day = nbt.m_128451_("day");
        }
        if (nbt.m_128441_("loadedTable")) {
            this.loadedTable = HordeTableLoader.INSTANCE.getTable(new ResourceLocation(nbt.m_128461_("loadedTable")));
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("timer", this.timer);
        nbt.m_128405_("nextDay", this.nextDay);
        nbt.m_128405_("day", this.day);
        if (this.loadedTable != null) {
            nbt.m_128359_("loadedTable", this.loadedTable.getName().toString());
        }
        this.hasChanged = false;
        return nbt;
    }

    public void update(Player player) {
        Level level = player.f_19853_;
        if (!level.f_46443_ && player != null && level.m_46472_() == Level.f_46428_) {
            if (this.timer % (Integer)CommonConfigHandler.hordeSpawnInterval.get() == 0) {
                int amount = (int)((double)((Integer)CommonConfigHandler.hordeSpawnAmount.get()).intValue() * (1.0 + (double)(this.day / (Integer)CommonConfigHandler.hordeSpawnDays.get()) * ((Double)CommonConfigHandler.hordeSpawnMultiplier.get() - 1.0)));
                List players = level.m_6907_();
                for (Player entity : players) {
                    if (entity == player || !(player.m_20270_((Entity)entity) <= 25.0f)) continue;
                    amount = (int)Math.floor((double)amount * (Double)CommonConfigHandler.hordeMultiplayerScaling.get());
                }
                this.spawnWave(player, amount);
            }
            --this.timer;
            if (this.timer == 0) {
                this.stopEvent(player, false);
            }
            this.hasChanged = true;
        }
    }

    @Override
    public void spawnWave(Player player, int count) {
        WeightedOutputs<HordeSpawnEntry> spawntable;
        this.cleanSpawns();
        HordeSpawnTable table = this.loadedTable;
        if (table == null) {
            HordeBuildSpawntableEvent buildTableEvent = new HordeBuildSpawntableEvent(player, HordeTableLoader.INSTANCE.getDefaultTable(), this);
            this.postEvent(buildTableEvent);
            table = buildTableEvent.spawntable;
        }
        if (table == null) {
            this.logError("Cannot load wave spawntable, cancelling spawns.", new Exception());
            return;
        }
        Level level = player.f_19853_;
        HordeStartWaveEvent startEvent = new HordeStartWaveEvent(player, this, count);
        this.postEvent(startEvent);
        if (startEvent.isCanceled()) {
            return;
        }
        count = startEvent.getCount();
        Vec3 basedir = DirectionUtils.getRandomDirectionVecXZ((Random)this.rand);
        BlockPos basepos = DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)player.m_20183_(), (Vec3)basedir, (double)75.0, (int)7, (int)0);
        int i = 0;
        while (basepos.equals((Object)player.m_20183_()) | !level.m_8055_(basepos.m_7495_()).m_60767_().m_76333_()) {
            basedir = DirectionUtils.getRandomDirectionVecXZ((Random)this.rand);
            basepos = DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)player.m_20183_(), (Vec3)basedir, (double)75.0, (int)7, (int)0);
            if (++i != 20) continue;
            this.logInfo("Unable to find unlit pos for horde " + this + " ignoring light level");
            basepos = DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)player.m_20183_(), (Vec3)basedir, (double)75.0);
            break;
        }
        if ((spawntable = table.getSpawnTable(this.day)).isEmpty()) {
            this.logInfo("Spawntable is empty, stopping wave spawn.");
            return;
        }
        if (count > 0) {
            if (player instanceof ServerPlayer) {
                HordeEventPacketHandler.NETWORK_INSTANCE.sendTo((Object)new HordeSoundMessage(basedir, startEvent.getSound()), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        } else {
            this.logInfo("Stopping wave spawn because count is " + count);
        }
        for (int n = 0; n < count; ++n) {
            if (this.entitiesSpawned.size() > (Integer)CommonConfigHandler.hordeSpawnMax.get()) {
                this.logInfo("Can't spawn wave because max cap has been reached");
                return;
            }
            Vec3 dir = DirectionUtils.getRandomDirectionVecXZ((Random)this.rand);
            BlockPos pos = DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)basepos, (Vec3)dir, (double)this.rand.nextInt(10));
            HordeSpawnEntry entry = (HordeSpawnEntry)spawntable.getResult(this.rand);
            EntityType<?> type = entry.getEntity();
            try {
                AtomicBoolean cancelled = new AtomicBoolean(false);
                CompoundTag nbt = entry.getNBT();
                nbt.m_128359_("id", entry.getName().toString());
                Mob newEntity = (Mob)EntityType.m_20645_((CompoundTag)nbt, (Level)level, entity -> {
                    Entity e = this.loadEntity(level, player, (Mob)entity, pos);
                    if (e instanceof Player) {
                        cancelled.set(true);
                        return null;
                    }
                    return e;
                });
                if (cancelled.get()) continue;
                newEntity.m_7378_(entry.getNBT());
                if (!((ServerLevel)level).m_8860_((Entity)newEntity)) {
                    this.logError("Unable to spawn entity from " + type, new Exception());
                    continue;
                }
                this.finalizeEntity(newEntity, level, player);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logError("Unable to spawn entity from " + type, e);
            }
        }
    }

    private Entity loadEntity(Level level, Player player, Mob entity, BlockPos pos) {
        HordeSpawnEntityEvent spawnEntityEvent = new HordeSpawnEntityEvent(player, entity, pos, this);
        this.postEvent(spawnEntityEvent);
        if (!spawnEntityEvent.isCanceled()) {
            entity = spawnEntityEvent.entity;
            pos = spawnEntityEvent.pos;
            entity.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), null, null, null);
            entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            return entity;
        }
        this.logInfo("Entity spawn event has been cancelled, not spawning entity  of class " + entity.m_6095_());
        return player;
    }

    private void finalizeEntity(Mob entity, Level level, Player player) {
        entity.m_21051_(Attributes.f_22277_).m_22100_(100.0);
        LazyOptional optional = entity.getCapability(Hordes.HORDESPAWN);
        if (optional.isPresent()) {
            ((IHordeSpawn)optional.resolve().get()).setPlayerUUID(player.m_20148_().toString());
            this.registerEntity(entity);
            this.hasChanged = true;
        }
        entity.f_21346_.m_25386_().forEach(goal -> goal.m_8041_());
        if (entity instanceof PathfinderMob) {
            entity.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)entity, new Class[0]));
        }
        entity.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(entity, Player.class, true));
        entity.f_21345_.m_25352_(6, (Goal)new HordeTrackPlayerGoal(entity, (Entity)player));
        for (Entity passenger : entity.m_20197_()) {
            if (!(passenger instanceof Mob)) continue;
            this.finalizeEntity((Mob)passenger, level, player);
        }
    }

    private void cleanSpawns() {
        ArrayList<Mob> toRemove = new ArrayList<Mob>();
        for (Mob entity : this.entitiesSpawned) {
            LazyOptional optional;
            if (!(entity.m_21224_() | !entity.m_6084_()) || !(optional = entity.getCapability(Hordes.HORDESPAWN, null)).isPresent()) continue;
            IHordeSpawn cap = (IHordeSpawn)optional.resolve().get();
            cap.setPlayerUUID("");
            toRemove.add(entity);
        }
        this.entitiesSpawned.removeAll(toRemove);
    }

    @Override
    public boolean isHordeDay(Player player) {
        Level level = player.f_19853_;
        if (level.f_46443_ | level.m_46472_() != Level.f_46428_) {
            return false;
        }
        return this.isActive(player) || (Boolean)CommonConfigHandler.hordesCommandOnly.get() == false && Math.floor(level.m_46468_() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue()) >= (double)this.nextDay;
    }

    public boolean isActive(Player player) {
        return this.timer > 0;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void setPlayer(Player player) {
        HashSet<Mob> toRemove = new HashSet<Mob>();
        for (Mob entity : this.entitiesSpawned) {
            if (entity != null) {
                GoToEntityPositionGoal task = null;
                for (WrappedGoal entry : (WrappedGoal[])entity.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
                    if (!(entry.m_26015_() instanceof GoToEntityPositionGoal)) continue;
                    task = (GoToEntityPositionGoal)entry.m_26015_();
                    break;
                }
                if (task == null) continue;
                entity.f_21345_.m_25363_(task);
                entity.f_21345_.m_25352_(6, (Goal)new HordeTrackPlayerGoal(entity, (Entity)player));
                continue;
            }
            toRemove.add(entity);
        }
        this.entitiesSpawned.removeAll(toRemove);
        this.hasChanged = true;
    }

    @Override
    public void tryStartEvent(Player player, int duration, boolean isCommand) {
        if (((Boolean)CommonConfigHandler.hordesCommandOnly.get()).booleanValue()) {
            return;
        }
        if (player != null) {
            Level level = player.f_19853_;
            if (level.m_46472_() == Level.f_46428_) {
                HordeStartEvent startEvent = new HordeStartEvent(player, this, isCommand);
                this.postEvent(startEvent);
                if (startEvent.isCanceled()) {
                    this.loadedTable = null;
                    return;
                }
                HordeSpawnTable table = this.loadedTable;
                if (table == null) {
                    HordeBuildSpawntableEvent buildTableEvent = new HordeBuildSpawntableEvent(player, HordeTableLoader.INSTANCE.getDefaultTable(), this);
                    this.postEvent(buildTableEvent);
                    table = buildTableEvent.spawntable;
                }
                if (!table.getSpawnTable(this.day).isEmpty()) {
                    this.timer = duration;
                    this.hasChanged = true;
                    this.sendMessage(player, startEvent.getMessage());
                    this.day = isCommand ? (int)Math.floor(level.m_46468_() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue()) : this.nextDay;
                } else {
                    this.loadedTable = null;
                    this.logInfo("Spawntable is empty, canceling event start.");
                }
                if (!isCommand) {
                    this.nextDay = HordeSavedData.getData((ServerLevel)level).getNextDay();
                }
            }
        } else {
            this.logError("player is null for " + this.toString(), new NullPointerException());
        }
    }

    @Override
    public void setSpawntable(HordeSpawnTable table) {
        this.loadedTable = table;
    }

    @Override
    public HordeSpawnTable getSpawntable() {
        return this.loadedTable;
    }

    @Override
    public void setNextDay(int day) {
        this.nextDay = day;
    }

    @Override
    public int getNextDay() {
        return this.nextDay;
    }

    private void sendMessage(Player player, String str) {
        HordeEventPacketHandler.NETWORK_INSTANCE.sendTo((Object)new SimpleStringMessage(str), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public void stopEvent(Player player, boolean isCommand) {
        HordeEndEvent endEvent = new HordeEndEvent(player, this, isCommand);
        this.postEvent(endEvent);
        this.timer = 0;
        this.cleanSpawns();
        this.sendMessage(player, endEvent.getMessage());
        this.hasChanged = true;
        this.loadedTable = null;
    }

    @Override
    public void removeEntity(Mob entity) {
        this.entitiesSpawned.remove(entity);
    }

    @Override
    public void registerEntity(Mob entity) {
        if (!this.entitiesSpawned.contains(entity)) {
            this.entitiesSpawned.add(entity);
        }
    }

    public String toString(Player player) {
        return "OngoingHordeEvent@" + Integer.toHexString(this.hashCode()) + "[player=" + (player == null ? "null" : player.m_7755_().getString()) + ", isActive=" + (this.timer > 0) + ", ticksLeft=" + this.timer + ", entityCount=" + this.entitiesSpawned.size() + ", nextDay=" + this.nextDay + ", day=" + this.day + "]";
    }

    private void logInfo(Object message) {
        HordesLogger.logInfo("[" + this + "]" + message);
    }

    private void logError(Object message, Exception e) {
        HordesLogger.logError("[" + this + "]" + message, e);
    }

    public List<String> getEntityStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\tentities: {" + (this.entitiesSpawned.isEmpty() ? "}" : ""));
        ArrayList<Mob> entitylist = new ArrayList<Mob>(this.entitiesSpawned);
        for (int i = 0; i < entitylist.size(); i += 10) {
            List sublist = entitylist.subList(i, Math.min(i + 9, entitylist.size() - 1));
            StringBuilder builder = new StringBuilder();
            builder.append("\t\t");
            for (Mob entity : sublist) {
                builder.append(entity.getClass().getSimpleName() + "@");
                builder.append(Integer.toHexString(entity.hashCode()));
                if (entitylist.indexOf(entity) >= entitylist.size() - 1) continue;
                builder.append(", ");
            }
            builder.append("}");
            result.add(builder.toString());
        }
        return result;
    }

    private void postEvent(HordePlayerEvent event) {
        for (HordeScript script : HordeScriptLoader.INSTANCE.getScripts(event)) {
            if (!script.shouldApply(event.getEntityWorld(), event.getEntity(), event.getEntityWorld().f_46441_)) continue;
            script.apply(event);
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public void reset(ServerLevel level) {
        this.entitiesSpawned.clear();
        HordeSavedData data = HordeSavedData.getData(level);
        this.nextDay = data.getNextDay();
        this.loadedTable = null;
        this.timer = 0;
    }
}

