/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.smileycorp.atlas.api.util.DirectionUtils;

public class FleeEntityGoal
extends Goal {
    protected final Mob entity;
    protected final Level level;
    protected final PathNavigation pather;
    protected int timeToRecalcPath = 0;
    protected float waterCost;
    protected final double speed;
    protected final double range;
    protected final Predicate<LivingEntity> predicate;

    public FleeEntityGoal(Mob entity, double speed, double range, Predicate<LivingEntity> predicate) {
        this.entity = entity;
        this.level = entity.f_19853_;
        this.pather = entity.m_21573_();
        this.predicate = predicate;
        this.speed = speed;
        this.range = range;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return !this.getEntities().isEmpty();
    }

    private List<LivingEntity> getEntities() {
        return this.level.m_6443_(LivingEntity.class, new AABB(this.entity.m_20185_() - this.range, this.entity.m_20186_() - this.range, this.entity.m_20189_() - this.range, this.entity.m_20185_() + this.range, this.entity.m_20189_() + this.range, this.entity.m_20189_() + this.range), this.predicate);
    }

    public void m_8056_() {
        this.waterCost = this.entity.m_21439_(BlockPathTypes.WATER);
    }

    public boolean m_8045_() {
        return true;
    }

    public void m_8041_() {
        this.pather.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.waterCost);
    }

    public void m_8037_() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 5;
            this.pather.m_26536_(this.pather.m_26556_(this.findSafePos(), 1), this.speed);
        }
    }

    private Stream<BlockPos> findSafePos() {
        Vec3 pos = this.entity.m_20182_();
        Vec3 resultDir = new Vec3(0.0, 0.0, 0.0);
        for (LivingEntity entity : this.getEntities()) {
            Vec3 dir = DirectionUtils.getDirectionVecXZ((Entity)this.entity, (Entity)entity);
            resultDir = new Vec3((dir.f_82479_ + resultDir.f_82479_) / 2.0, (dir.f_82480_ + resultDir.f_82480_) / 2.0, (dir.f_82481_ + resultDir.f_82481_) / 2.0);
        }
        return Stream.of(this.level.m_5452_(Heightmap.Types.WORLD_SURFACE, new BlockPos(pos.m_82549_(resultDir.m_82548_().m_82542_(5.0, 0.0, 5.0)))));
    }
}

