/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.smileycorp.hordes.client.ClientConfigHandler;
import net.smileycorp.hordes.client.ClientHandler;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.MiscEventHandler;
import net.smileycorp.hordes.common.capability.IZombifyPlayer;
import net.smileycorp.hordes.common.hordeevent.HordeEventHandler;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeSpawn;
import net.smileycorp.hordes.common.hordeevent.data.DefaultDataGenerator;
import net.smileycorp.hordes.common.hordeevent.data.scripts.HordeScriptRegistry;
import net.smileycorp.hordes.common.hordeevent.network.HordeEventPacketHandler;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionEventHandler;
import net.smileycorp.hordes.common.infection.InfectionRegister;
import net.smileycorp.hordes.common.infection.capability.IInfection;
import net.smileycorp.hordes.common.infection.network.InfectionPacketHandler;

@Mod(value="hordes")
@Mod.EventBusSubscriber(modid="hordes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Hordes {
    public static final Capability<IHordeEvent> HORDE_EVENT = CapabilityManager.get((CapabilityToken)new CapabilityToken<IHordeEvent>(){});
    public static final Capability<IHordeSpawn> HORDESPAWN = CapabilityManager.get((CapabilityToken)new CapabilityToken<IHordeSpawn>(){});
    public static final Capability<IZombifyPlayer> ZOMBIFY_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IZombifyPlayer>(){});
    public static final Capability<IInfection> INFECTION = CapabilityManager.get((CapabilityToken)new CapabilityToken<IInfection>(){});

    public Hordes() {
        HordesLogger.clearLog();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfigHandler.config);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfigHandler.config);
        if (DefaultDataGenerator.tryGenerateDataFiles()) {
            HordesLogger.logInfo("Generated default config files.");
        } else {
            HordesLogger.logInfo("Config files exist, skipping generation");
        }
    }

    @SubscribeEvent
    public static void constructMod(FMLConstructModEvent event) {
        if (((Boolean)CommonConfigHandler.enableHordeEvent.get()).booleanValue()) {
            HordeScriptRegistry.init();
            HordeEventPacketHandler.initPackets();
            MinecraftForge.EVENT_BUS.register((Object)new HordeEventHandler());
        } else {
            MinecraftForge.EVENT_BUS.unregister(HordeEventHandler.class);
        }
        if (((Boolean)CommonConfigHandler.enableMobInfection.get()).booleanValue()) {
            InfectionPacketHandler.initPackets();
            MinecraftForge.EVENT_BUS.register((Object)new InfectionEventHandler());
        } else {
            MinecraftForge.EVENT_BUS.unregister(InfectionEventHandler.class);
        }
        MinecraftForge.EVENT_BUS.register((Object)new MiscEventHandler());
        HordesInfection.EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        HordesInfection.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public static void loadComplete(FMLLoadCompleteEvent event) {
        if (((Boolean)CommonConfigHandler.enableMobInfection.get()).booleanValue()) {
            InfectionRegister.readConfig();
        }
    }

    @SubscribeEvent
    public static void loadClient(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
    }
}

