/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client.render;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Zombie;
import net.smileycorp.atlas.api.client.PlayerTextureRenderer;
import net.smileycorp.hordes.client.render.ZombiePlayerCapeLayer;
import net.smileycorp.hordes.client.render.ZombiePlayerElytraLayer;
import net.smileycorp.hordes.client.render.ZombiePlayerModel;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.entities.IZombiePlayer;

public class ZombiePlayerRenderer<T extends Zombie>
extends HumanoidMobRenderer<T, ZombiePlayerModel<T>> {
    public static final ModelLayerLocation DEFAULT = new ModelLayerLocation(Constants.loc("zombie_player"), "default");
    public static final ModelLayerLocation SLIM = new ModelLayerLocation(Constants.loc("zombie_player"), "slim");
    protected final ZombiePlayerModel<T> defaultModel;
    protected final ZombiePlayerModel<T> slimModel;

    public ZombiePlayerRenderer(EntityRendererProvider.Context ctx, Color colour) {
        super(ctx, new ZombiePlayerModel(ctx.m_174023_(DEFAULT), colour), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new ZombieModel(ctx.m_174023_(ModelLayers.f_171226_)), (HumanoidModel)new ZombieModel(ctx.m_174023_(ModelLayers.f_171227_))));
        this.m_115326_(new ZombiePlayerCapeLayer(this));
        this.m_115326_((RenderLayer)new ZombiePlayerElytraLayer(this, ctx.m_174027_()));
        this.defaultModel = (ZombiePlayerModel)this.f_115290_;
        this.slimModel = new ZombiePlayerModel(ctx.m_174023_(SLIM), colour);
    }

    public ResourceLocation getTextureLocation(T entity) {
        Optional<UUID> optional = ((IZombiePlayer)entity).getPlayerUUID();
        return PlayerTextureRenderer.getTexture(optional, (MinecraftProfileTexture.Type)MinecraftProfileTexture.Type.SKIN);
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        Optional<UUID> optional = ((IZombiePlayer)entity).getPlayerUUID();
        boolean isSlim = "slim".equals(PlayerTextureRenderer.getSkinType(optional));
        if (isSlim && this.f_115290_ != this.slimModel) {
            this.f_115290_ = this.slimModel;
        } else if (!isSlim && this.f_115290_ != this.defaultModel) {
            this.f_115290_ = this.defaultModel;
        }
        super.m_7392_(entity, yaw, partialTicks, poseStack, bufferSource, packedLightIn);
    }

    public static LayerDefinition createLayer(boolean slim) {
        return LayerDefinition.m_171565_((MeshDefinition)ZombiePlayerModel.m_170825_((CubeDeformation)CubeDeformation.f_171458_, (boolean)slim), (int)64, (int)64);
    }
}

