/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.util;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import javax.annotation.Nullable;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.renderer.GeoArmorRenderer;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.GeoReplacedEntityRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public final class RenderUtils {
    public static void translateMatrixToBone(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.m_85837_((double)(-bone.getPosX() / 16.0f), (double)(bone.getPosY() / 16.0f), (double)(bone.getPosZ() / 16.0f));
    }

    public static void rotateMatrixAroundBone(PoseStack poseStack, CoreGeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(bone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(PoseStack poseStack, GeoCube cube) {
        Vec3 rotation = cube.rotation();
        poseStack.m_85845_(new Quaternion(0.0f, 0.0f, (float)rotation.m_7094_(), false));
        poseStack.m_85845_(new Quaternion(0.0f, (float)rotation.m_7098_(), 0.0f, false));
        poseStack.m_85845_(new Quaternion((float)rotation.m_7096_(), 0.0f, 0.0f, false));
    }

    public static void scaleMatrixForBone(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.m_85841_(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.m_85837_(pivot.m_7096_() / 16.0, pivot.m_7098_() / 16.0, pivot.m_7094_() / 16.0);
    }

    public static void translateToPivotPoint(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.m_85837_((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.m_85837_(-pivot.m_7096_() / 16.0, -pivot.m_7098_() / 16.0, -pivot.m_7094_() / 16.0);
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.m_85837_((double)(-bone.getPivotX() / 16.0f), (double)(-bone.getPivotY() / 16.0f), (double)(-bone.getPivotZ() / 16.0f));
    }

    public static void translateAndRotateMatrixForBone(PoseStack poseStack, CoreGeoBone bone) {
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(PoseStack poseStack, CoreGeoBone bone) {
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f(inputMatrix);
        inputMatrix.m_27657_();
        inputMatrix.m_27644_(baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(PoseStack poseStack, Entity animatable, float partialTick) {
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTick, (float)animatable.f_19859_, (float)animatable.m_146908_()) - 90.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTick, (float)animatable.f_19860_, (float)animatable.m_146909_())));
    }

    @Nullable
    public static IntIntPair getTextureDimensions(ResourceLocation texture) {
        if (texture == null) {
            return null;
        }
        AbstractTexture originalTexture = null;
        Minecraft mc = Minecraft.m_91087_();
        try {
            originalTexture = (AbstractTexture)mc.m_18691_(() -> mc.m_91097_().m_118506_(texture)).get();
        }
        catch (Exception e) {
            AzureLib.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        NativeImage image = null;
        try {
            NativeImage nativeImage;
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                nativeImage = dynamicTexture.m_117991_();
            } else {
                nativeImage = NativeImage.m_85058_((InputStream)((Resource)mc.m_91098_().m_213713_(texture).get()).m_215507_());
            }
            image = nativeImage;
        }
        catch (Exception e) {
            AzureLib.LOGGER.error("Failed to read image for id {}", (Object)texture);
            e.printStackTrace();
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.m_84982_(), (int)image.m_85084_());
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return Blaze3D.m_83640_() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static Vec3 arrayToVec(double[] array) {
        return new Vec3(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(ModelPart from, CoreGeoBone to) {
        to.updateRotation(-from.f_104203_, -from.f_104204_, from.f_104205_);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.m_122239_() < 0.0f && (cube.size().m_7098_() == 0.0 || cube.size().m_7094_() == 0.0)) {
            normal.m_122263_(-1.0f, 1.0f, 1.0f);
        }
        if (normal.m_122260_() < 0.0f && (cube.size().m_7096_() == 0.0 || cube.size().m_7094_() == 0.0)) {
            normal.m_122263_(1.0f, -1.0f, 1.0f);
        }
        if (normal.m_122269_() < 0.0f && (cube.size().m_7096_() == 0.0 || cube.size().m_7098_() == 0.0)) {
            normal.m_122263_(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> 90.0f;
            case Direction.NORTH -> 270.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntityType(EntityType<?> entityType) {
        GeoModel geoModel;
        EntityRenderer renderer = (EntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(entityType);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoAnimatable getReplacedAnimatable(EntityType<?> entityType) {
        GeoAnimatable geoAnimatable;
        EntityRenderer renderer = (EntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(entityType);
        if (renderer instanceof GeoReplacedEntityRenderer) {
            GeoReplacedEntityRenderer replacedEntityRenderer = (GeoReplacedEntityRenderer)renderer;
            geoAnimatable = (GeoAnimatable)replacedEntityRenderer.getAnimatable();
        } else {
            geoAnimatable = null;
        }
        return geoAnimatable;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntity(Entity entity) {
        GeoModel geoModel;
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(entity);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForItem(Item item) {
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = IClientItemExtensions.of((Item)item).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)blockEntityWithoutLevelRenderer;
            return geoRenderer.getGeoModel();
        }
        return null;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForBlock(BlockEntity blockEntity) {
        GeoModel geoModel;
        BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(blockEntity);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForArmor(ItemStack stack) {
        HumanoidModel humanoidModel = IClientItemExtensions.of((ItemStack)stack).getHumanoidArmorModel(null, stack, null, null);
        if (humanoidModel instanceof GeoArmorRenderer) {
            GeoArmorRenderer armorRenderer = (GeoArmorRenderer)humanoidModel;
            return armorRenderer.getGeoModel();
        }
        return null;
    }
}

