/*
 * Decompiled with CFR 0.152.
 */
package entities;

import block.ModBlocks;
import block.TileEntityBeacon;
import com.mialliance.MiCon;
import com.mialliance.ModSounds;
import com.mojang.logging.LogUtils;
import entities.EntityMi;
import entities.EntityTracker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class MiTrackerGoal
extends Goal {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final EntityTracker mob;
    protected Player play;
    protected List<BlockPos> playBlockPos = new ArrayList<BlockPos>();
    protected List<BlockPos> blockPosList = new ArrayList<BlockPos>();
    protected List<BlockState> blockStateList = new ArrayList<BlockState>();
    private int test;
    private int capturePos;
    private int battleTacticTimer;
    private int hideTimer = 0;
    private boolean stalkHasInformed = false;

    public MiTrackerGoal(EntityTracker p_i1636_1_) {
        this.mob = p_i1636_1_;
    }

    public boolean m_8036_() {
        return true;
    }

    public boolean m_8045_() {
        return true;
    }

    public void m_8056_() {
        this.play = this.mob.m_9236_().m_45930_((Entity)this.mob, 256.0);
        if (this.mob.Objective == null) {
            this.mob.Objective = "";
        }
    }

    public void m_8041_() {
    }

    public void m_8037_() {
        if (this.test-- < 1) {
            this.test = 5;
            Level wo = this.mob.f_19853_;
            RandomSource rr = wo.m_213780_();
            this.play = this.mob.m_9236_().m_45930_((Entity)this.mob, 256.0);
            if (this.play != null && this.capturePos-- < 0 && this.play.m_20096_() && this.BlockDisTotal(this.PlayPos()) > 24.0) {
                this.capturePos = 50;
                this.playBlockPos.add(this.PlayPos());
                if (this.playBlockPos.size() > 120) {
                    this.playBlockPos.remove(0);
                }
            }
            switch (this.mob.Objective) {
                case "": {
                    this.setMission("FindHome");
                    break;
                }
                case "FindHome": {
                    this.navigateTowards(this.mob.ObjectiveTarget2, 1.0f);
                    if (!(this.BlockDisTotal(this.mob.ObjectiveTarget2) < 2.0)) break;
                    this.setMission("Rest");
                    break;
                }
                case "Rest": {
                    this.restHouse();
                    break;
                }
                case "Stalk": {
                    if (this.play == null || this.enemyNearby() || this.mob.m_21223_() / this.mob.m_21233_() < 0.75f) {
                        this.setMission("Retreat");
                        return;
                    }
                    if (this.play.m_142582_((Entity)this.mob)) {
                        if (this.PlayDis() < 46.0f || rr.m_188503_(18) == 0 && this.stalkHasInformed) {
                            ++this.mob.ObjectiveProgress;
                            if (this.hideTimer < 10) {
                                ++this.mob.SpyData;
                            }
                            this.hideTimer = 20;
                            this.mob.ObjectiveTarget = this.getRun(12, true);
                            this.navigateTowards(this.mob.ObjectiveTarget, 1.2f);
                        } else {
                            this.stalkHasInformed = true;
                            this.mob.m_21573_().m_26573_();
                            this.mob.m_21391_((Entity)this.play, 5.0f, 5.0f);
                            if (rr.m_188503_(14) == 0) {
                                this.informAllies();
                                ++this.mob.ObjectiveProgress;
                            }
                            return;
                        }
                    }
                    if (this.hideTimer > 0) {
                        if (this.PlayDis() > 32.0f) {
                            --this.hideTimer;
                        } else {
                            this.hideTimer = 20;
                            this.mob.ObjectiveTarget = this.getRun(6, false).m_7495_();
                            this.navigateTowards(this.mob.ObjectiveTarget, 1.0f);
                            if (this.PlayDis() < 8.0f && this.mob.m_142582_((Entity)this.play)) {
                                if (rr.m_188503_(3) == 0) {
                                    this.setMission("Strike");
                                } else {
                                    this.setMission("Retreat");
                                }
                                return;
                            }
                        }
                        if (this.hideTimer != 0) break;
                        if (rr.m_188503_(4) == 0) {
                            this.setMission("Retreat");
                            return;
                        }
                        this.mob.ObjectiveTarget = this.getVisitedPos();
                        break;
                    }
                    if (this.PlayDis() < 28.0f) {
                        if (wo.m_45527_(this.mob.m_20183_())) {
                            this.mob.ObjectiveTarget = this.getRun(6, false).m_7495_();
                            break;
                        }
                        this.mob.m_21573_().m_26573_();
                        break;
                    }
                    if (this.BlockDisHorizontal(this.mob.ObjectiveTarget) < 3.0) {
                        this.mob.ObjectiveProgress += 2;
                        ++this.mob.SpyData;
                        this.mob.ObjectiveTarget = this.PlayPos();
                        if (rr.m_188503_(10) + 7 >= this.mob.ObjectiveProgress + 1) break;
                        this.setMission("Retreat");
                        break;
                    }
                    this.navigateTowards(this.mob.ObjectiveTarget, 1.0f);
                    break;
                }
                case "Sabotage": {
                    if (this.play == null || this.enemyNearby() || this.mob.m_21223_() / this.mob.m_21233_() < 0.75f) {
                        this.setMission("Retreat");
                        return;
                    }
                    if (this.mob.m_142582_((Entity)this.play)) {
                        if (this.PlayDis() < 40.0f || rr.m_188503_(10) == 0) {
                            this.hideTimer = 40;
                            this.mob.ObjectiveTarget = this.getRun(12, false).m_6625_(3);
                            this.navigateTowards(this.mob.ObjectiveTarget, 1.0f);
                        } else {
                            this.mob.m_21573_().m_26573_();
                            this.mob.m_21391_((Entity)this.play, 5.0f, 5.0f);
                            return;
                        }
                    }
                    if (this.hideTimer > 0) {
                        if (this.PlayDis() > 32.0f) {
                            --this.hideTimer;
                        } else {
                            this.hideTimer = 40;
                            this.mob.ObjectiveTarget = this.getRun(6, false).m_7495_();
                            this.navigateTowards(this.mob.ObjectiveTarget, 1.0f);
                            if (this.PlayDis() < 8.0f && this.mob.m_142582_((Entity)this.play)) {
                                if (rr.m_188503_(3) == 0) {
                                    this.setMission("Strike");
                                } else {
                                    this.setMission("Retreat");
                                }
                                return;
                            }
                        }
                        if (this.hideTimer != 0) break;
                        if (rr.m_188503_(3) == 0) {
                            this.setMission("Retreat");
                            return;
                        }
                        this.mob.ObjectiveTarget = this.getVisitedPos();
                        break;
                    }
                    if (this.PlayDis() < 28.0f) {
                        if (wo.m_45527_(this.mob.m_20183_())) {
                            this.mob.ObjectiveTarget = this.getRun(6, false).m_7495_();
                            break;
                        }
                        this.mob.m_21573_().m_26573_();
                        break;
                    }
                    if (this.BlockDisHorizontal(this.mob.ObjectiveTarget) < 3.0) {
                        int prank = rr.m_188503_(6);
                        if (prank == 3 && !((Boolean)MiCon.GRIEFING_DESTRUCTION.get()).booleanValue()) {
                            prank = 0;
                        }
                        switch (prank) {
                            case 0: {
                                wo.m_7731_(this.mob.ObjectiveTarget, ((Block)ModBlocks.METALLIUM_MINE.get()).m_49966_(), 3);
                                break;
                            }
                            case 1: {
                                Explosion.BlockInteraction explosion$mode = (Boolean)MiCon.GRIEFING_DESTRUCTION.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
                                boolean boom = (Boolean)MiCon.GRIEFING_FIRE.get();
                                this.mob.f_19853_.m_46518_((Entity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), 4.0f, boom, explosion$mode);
                                break;
                            }
                            case 2: {
                                wo.m_7731_(this.mob.ObjectiveTarget, ((Block)ModBlocks.METALLIUM_MINE.get()).m_49966_(), 3);
                                break;
                            }
                            case 3: {
                                for (int ix = -8; ix < 9; ++ix) {
                                    for (int iy = -1; iy < 5; ++iy) {
                                        for (int iz = -8; iz < 9; ++iz) {
                                            BlockPos po = this.mob.ObjectiveTarget.m_7918_(ix, iy, iz);
                                            BlockState stat = wo.m_8055_(po);
                                            if (stat.getLightEmission((BlockGetter)wo, po) <= 6 || !this.mob.canBeMined(stat)) continue;
                                            wo.m_46961_(po, true);
                                        }
                                    }
                                }
                                break;
                            }
                            default: {
                                wo.m_7731_(this.mob.ObjectiveTarget, Blocks.f_50095_.m_49966_(), 3);
                                SignBlockEntity sign = (SignBlockEntity)wo.m_7702_(this.mob.ObjectiveTarget);
                                if (sign == null) break;
                                this.evilSign(sign);
                            }
                        }
                        ++this.mob.ObjectiveProgress;
                        this.mob.ObjectiveTarget = this.getVisitedPos();
                        if (rr.m_188503_(5) + 3 >= this.mob.ObjectiveProgress + 1) break;
                        this.setMission("Retreat");
                        break;
                    }
                    this.navigateTowards(this.mob.ObjectiveTarget, 1.0f);
                    break;
                }
                case "Ambush": {
                    if (this.play == null) {
                        this.setMission("Retreat");
                        return;
                    }
                    if (this.mob.m_142582_((Entity)this.play) || this.PlayDis() < 10.0f) {
                        this.setMission("Strike");
                        return;
                    }
                    if (this.BlockDisHorizontal(this.mob.ObjectiveTarget) < 3.0) {
                        this.navigateTowards(this.mob.ObjectiveTarget.m_6625_(3), 1.0f);
                        ++this.mob.ObjectiveProgress;
                        if (this.PlayDis() > 150.0f) {
                            this.setMission("Ambush");
                            break;
                        }
                        if (this.mob.ObjectiveProgress <= 300) break;
                        this.setMission("Hunt");
                        break;
                    }
                    this.navigateTowards(this.mob.ObjectiveTarget, 1.0f);
                    break;
                }
                case "Hunt": {
                    if (this.play == null) {
                        this.setMission("Retreat");
                        return;
                    }
                    if (this.PlayDis() < 16.0f) {
                        this.setMission("Strike");
                        return;
                    }
                    if (this.PlayDis() < 32.0f && this.mob.ObjectiveProgress == 0) {
                        ++this.mob.ObjectiveProgress;
                        this.informAllies();
                    }
                    this.navigateTowards(this.PlayPos(), 1.0f);
                    break;
                }
                case "Strike": {
                    if (this.play == null) {
                        this.setMission("Retreat");
                        return;
                    }
                    if (this.mob.m_21223_() / this.mob.m_21233_() + rr.m_188501_() * 2.0f < this.play.m_21223_() / this.play.m_21233_()) {
                        this.setMission("Retreat");
                        return;
                    }
                    if (!this.mob.m_142582_((Entity)this.play)) {
                        this.navigateTowards(this.PlayPos(), 1.2f);
                        break;
                    }
                    if (this.battleTacticTimer-- >= 1) break;
                    this.setBattleTactic();
                    break;
                }
                case "Retreat": {
                    this.navigateTowards(this.mob.ObjectiveTarget2, 1.4f);
                    if (!(this.BlockDisTotal(this.mob.ObjectiveTarget2) < 2.0)) break;
                    this.setMission("Rest");
                }
            }
        }
    }

    private BlockPos getRun(int dist, boolean doNavmesh) {
        Level wo = this.mob.m_9236_();
        Vec3 vo = new Vec3((double)(this.PlayPos().m_123341_() - this.mob.m_20183_().m_123341_()), 0.0, (double)(this.PlayPos().m_123343_() - this.mob.m_20183_().m_123343_())).m_82541_().m_82542_((double)(-dist), (double)(-dist), (double)(-dist));
        Vec3 go = new Vec3((double)this.mob.m_20183_().m_123341_() + vo.f_82479_, (double)this.mob.m_20183_().m_123342_(), (double)this.mob.m_20183_().m_123343_() + vo.f_82481_);
        BlockPos pos = new BlockPos(go.m_7096_(), go.m_7098_(), go.m_7094_());
        if (doNavmesh) {
            return wo.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
        }
        while (!wo.m_8055_(pos.m_7495_()).m_60767_().m_76337_()) {
            pos = pos.m_7495_();
        }
        return pos;
    }

    private void setBattleTactic() {
        Level wo = this.mob.m_9236_();
        RandomSource rr = wo.m_213780_();
        if (this.mob.m_5448_() != this.play) {
            if (this.PlayDis() < 45.0f) {
                this.mob.m_6710_((LivingEntity)this.play);
            } else {
                this.setMission("Retreat");
                return;
            }
        }
        switch (1 + rr.m_188503_(3)) {
            case 1: {
                this.mob.m_216990_((SoundEvent)ModSounds.INCINERATOR_AMBIENT.get());
                this.mob.Tactic = "Surround";
                this.mob.TacticPos = this.PlayPos();
                this.mob.TacticTimer = 40;
                this.battleTacticTimer = 11 + rr.m_188503_(5);
                this.mob.Stance = 2;
                break;
            }
            case 2: {
                this.mob.m_216990_((SoundEvent)ModSounds.INCINERATOR_ATTACK.get());
                this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60, 0, false, false));
                this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 2, false, false));
                this.mob.setBlocking(60);
                this.mob.Tactic = "Surround";
                this.mob.TacticPos = this.PlayPos();
                this.mob.TacticTimer = 40;
                this.battleTacticTimer = 15 + rr.m_188503_(5);
                this.mob.Stance = 1;
                break;
            }
            case 3: {
                this.mob.m_216990_((SoundEvent)ModSounds.INCINERATOR_AMBIENT.get());
                this.mob.Tactic = "Surround";
                this.mob.TacticPos = this.getRun(-5, true);
                this.mob.TacticTimer = 80;
                this.battleTacticTimer = 12 + rr.m_188503_(10);
                this.mob.Stance = 3;
            }
        }
    }

    private void restHouse() {
        Level wo = this.mob.m_9236_();
        RandomSource rr = wo.m_213780_();
        float playDis = this.PlayDis();
        if (playDis < 10.0f && this.mob.m_142582_((Entity)this.play)) {
            this.setMission("Strike");
            this.mob.SpyCompromised = true;
            return;
        }
        for (int ix = -3; ix < 4; ++ix) {
            for (int iz = -3; iz < 4; ++iz) {
                for (int iy = -1; iy < 3; ++iy) {
                    BlockPos mine = this.mob.ObjectiveTarget2.m_7918_(ix, iy, iz);
                    if (!wo.m_6425_(mine).m_76178_()) {
                        this.setMission("FindHome");
                        this.mob.SpyCompromised = true;
                        return;
                    }
                    if (!this.mob.canBeMined(wo.m_8055_(mine))) {
                        return;
                    }
                    if (Math.abs(ix) == 3 || Math.abs(iz) == 3 || iy == -1) {
                        if (wo.m_8055_(mine).m_60713_((Block)ModBlocks.MITREAN_PLANKS.get())) continue;
                        wo.m_7731_(mine, ((Block)ModBlocks.MITREAN_PLANKS.get()).m_49966_(), 3);
                        this.test = 1;
                        if (this.mob.ObjectiveProgress > 50) {
                            --this.mob.ObjectiveProgress;
                        }
                        return;
                    }
                    if (iy == 0 && ix == 2 && iz == 2) {
                        if (wo.m_8055_(mine).m_60713_((Block)ModBlocks.MITREAN_CORE.get())) continue;
                        wo.m_7731_(mine, ((Block)ModBlocks.MITREAN_CORE.get()).m_49966_(), 3);
                        return;
                    }
                    if (iy == 0 && ix == 1 && iz == 2) {
                        if (wo.m_8055_(mine).m_60713_((Block)ModBlocks.MI_BEACON.get())) continue;
                        wo.m_7731_(mine, ((Block)ModBlocks.MI_BEACON.get()).m_49966_(), 3);
                        TileEntityBeacon tit2 = (TileEntityBeacon)wo.m_7702_(mine);
                        if (tit2 != null) {
                            tit2.Tech = this.mob.PowerLevel;
                        }
                        return;
                    }
                    if (iy == 0 && ix == 0 && iz == 2) {
                        if (wo.m_8055_(mine).m_60713_(Blocks.f_50091_)) continue;
                        wo.m_7731_(mine, Blocks.f_50091_.m_49966_(), 3);
                        return;
                    }
                    if ((iy == 0 || iy == 1) && ix == -1 && iz == 2) {
                        if (wo.m_8055_(mine).m_60713_(Blocks.f_50094_)) continue;
                        wo.m_7731_(mine, Blocks.f_50094_.m_49966_(), 3);
                        return;
                    }
                    if (wo.m_8055_(mine).m_60795_()) continue;
                    wo.m_46961_(mine, false);
                    this.test = 2;
                    if (this.mob.ObjectiveProgress > 50) {
                        --this.mob.ObjectiveProgress;
                    }
                    return;
                }
            }
        }
        this.capturePos -= 3;
        this.test = 20;
        --this.mob.ObjectiveProgress;
        this.mob.m_5634_(1.0f);
        if (this.mob.ObjectiveProgress < 1 && this.play != null && this.playBlockPos.size() > 8) {
            float randommission = rr.m_188501_() + (float)this.mob.SpyData * 0.1f;
            if (randommission > 1.4f) {
                if (rr.m_188499_()) {
                    this.setMission("Hunt");
                } else {
                    this.setMission("Ambush");
                }
            } else if (randommission > 0.8f) {
                this.setMission("Sabotage");
            } else {
                this.setMission("Stalk");
            }
        }
    }

    private BlockPos PlayPos() {
        if (this.play == null) {
            return this.mob.m_20183_();
        }
        return this.play.m_20183_();
    }

    private float PlayDis() {
        if (this.play == null) {
            return 999.0f;
        }
        return this.mob.m_20270_((Entity)this.play);
    }

    private void setMission(String str) {
        Level wo = this.mob.f_19853_;
        RandomSource rr = wo.m_213780_();
        this.mob.Objective = str;
        this.mob.ObjectiveProgress = 0;
        this.mob.canAttack = false;
        this.hideTimer = 0;
        switch (this.mob.Objective) {
            case "": {
                break;
            }
            case "FindHome": {
                BlockPos here;
                if (this.mob.ObjectiveTarget2 != null && !this.mob.SpyCompromised) break;
                int Approved = 0;
                BlockPos testpos = here = this.PlayPos();
                if (here == null) {
                    here = this.mob.m_20183_();
                }
                while (Approved < 20) {
                    ++Approved;
                    int ixoff = 40 + rr.m_188503_(20);
                    if (rr.m_188499_()) {
                        ixoff *= -1;
                    }
                    int izoff = 40 + rr.m_188503_(20);
                    if (rr.m_188499_()) {
                        izoff *= -1;
                    }
                    testpos = here.m_7918_(ixoff, rr.m_188503_(6) - 6, izoff);
                    while (wo.m_45527_(testpos) && wo.m_6425_(testpos = testpos.m_6625_(3)).m_76178_()) {
                    }
                    if (!wo.m_6425_(testpos).m_76178_() || !wo.m_6425_(testpos = testpos.m_6625_(9)).m_76178_()) continue;
                    Approved = 20;
                }
                this.mob.SpyCompromised = false;
                this.mob.ObjectiveTarget2 = testpos;
                break;
            }
            case "Rest": {
                this.mob.ObjectiveProgress = 40 + rr.m_188503_(70);
                break;
            }
            case "Stalk": {
                this.stalkHasInformed = false;
                this.mob.ObjectiveTarget = this.PlayPos();
                break;
            }
            case "Sabotage": {
                this.mob.ObjectiveTarget = this.getVisitedPos();
                break;
            }
            case "Ambush": {
                this.mob.ObjectiveTarget = this.getVisitedPos();
                break;
            }
            case "Hunt": {
                this.mob.ObjectiveTarget = this.getVisitedPos();
                break;
            }
            case "Retreat": {
                this.mob.m_216990_(SoundEvents.f_11928_);
                if (this.play != null && this.PlayDis() < 14.0f) {
                    this.play.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false));
                    this.play.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 200, 0, false, false));
                }
                if (!this.mob.SpyCompromised) break;
                this.setMission("FindHome");
                break;
            }
            case "Strike": {
                this.mob.canAttack = true;
                this.mob.m_216990_((SoundEvent)ModSounds.INCINERATOR_AMBIENT.get());
                this.mob.m_216990_((SoundEvent)ModSounds.SFX_TRACKER_STATIC.get());
                this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 0, false, false));
                this.battleTacticTimer = 8;
                if (this.play == null || !(this.PlayDis() < 14.0f)) break;
                this.play.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false));
                this.play.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 200, 0, false, false));
            }
        }
    }

    private BlockPos getVisitedPos() {
        if (this.playBlockPos.isEmpty()) {
            return this.PlayPos();
        }
        return this.playBlockPos.get(this.mob.m_9236_().m_213780_().m_188503_(this.playBlockPos.size()));
    }

    private void navigateTowards(BlockPos trt, float speed) {
        if (this.PlayDis() < 6.0f) {
            this.test += 4;
        }
        Path path = this.mob.m_21573_().m_7864_(trt, 0);
        Level wo = this.mob.m_9236_();
        BlockPos pos = this.mob.m_20183_();
        boolean nav = this.mob.m_21573_().m_26536_(path, (double)speed);
        Vec3 diff = new Vec3((double)(trt.m_123341_() - pos.m_123341_()), (double)(trt.m_123342_() - pos.m_123342_()), (double)(trt.m_123343_() - pos.m_123343_())).m_82541_();
        if (!wo.m_6425_(pos).m_76178_()) {
            return;
        }
        BlockPos check = pos.m_7918_((int)Math.round(diff.m_7096_()), (int)Math.round(diff.m_7098_()), (int)Math.round(diff.m_7094_()));
        if ((int)Math.round(diff.m_7096_()) == 0 && (int)Math.round(diff.m_7098_()) == 0 && (int)Math.round(diff.m_7094_()) == 0) {
            if (trt.m_123341_() - pos.m_123341_() > 0) {
                check = check.m_7918_(1, 0, 0);
            } else if (trt.m_123341_() - pos.m_123341_() < 0) {
                check = check.m_7918_(-1, 0, 0);
            }
            if (trt.m_123343_() - pos.m_123343_() > 0) {
                check = check.m_7918_(0, 0, 1);
            } else if (trt.m_123343_() - pos.m_123343_() < 0) {
                check = check.m_7918_(0, 0, -1);
            }
            if (trt.m_123342_() - pos.m_123342_() > 0) {
                check = check.m_7918_(0, 1, 0);
            } else if (trt.m_123342_() - pos.m_123342_() < 0) {
                check = check.m_7918_(0, -1, 0);
            }
        }
        if (Math.abs(check.m_123341_() - pos.m_123341_()) > 0 && Math.abs(check.m_123343_() - pos.m_123343_()) > 0) {
            check = pos.m_7918_((int)Math.round(diff.m_7096_()), (int)Math.round(diff.m_7098_()), 0);
        }
        if ((int)Math.round(diff.m_7096_()) == 0 && (int)Math.round(diff.m_7098_()) == 0 && (int)Math.round(diff.m_7094_()) == 0) {
            if (trt.m_123341_() - pos.m_123341_() > 0) {
                check = check.m_7918_(1, 0, 0);
            } else if (trt.m_123341_() - pos.m_123341_() < 0) {
                check = check.m_7918_(-1, 0, 0);
            }
            if (trt.m_123343_() - pos.m_123343_() > 0) {
                check = check.m_7918_(0, 0, 1);
            } else if (trt.m_123343_() - pos.m_123343_() < 0) {
                check = check.m_7918_(0, 0, -1);
            }
        }
        if (Math.abs(check.m_123342_() - pos.m_123342_()) > 0 || (double)Math.abs(trt.m_123342_() - pos.m_123342_()) > this.BlockDisHorizontal(trt) || !nav || !wo.m_45527_(check)) {
            this.mineAndReplace(check);
            this.mineAndReplace(pos);
            this.mineAndReplace(pos.m_7494_());
            this.mineAndReplace(check.m_7494_());
            if (!wo.m_6425_(check).m_76178_()) {
                if (this.blockStateList.size() > 6) {
                    this.mob.m_9236_().m_7731_(this.blockPosList.get(0), this.blockStateList.get(0), 3);
                    this.blockStateList.remove(0);
                    this.blockPosList.remove(0);
                }
                BlockState stat = this.mob.m_9236_().m_8055_(check);
                this.blockStateList.add(stat);
                this.blockPosList.add(pos);
                wo.m_7731_(check, Blocks.f_50056_.m_49966_(), 3);
            }
            path = this.mob.m_21573_().m_7864_(check, 0);
            this.mob.m_6021_((double)check.m_123341_() + 0.5, (double)check.m_123342_() + 0.5, (double)check.m_123343_() + 0.5);
            this.mob.m_21573_().m_26536_(path, (double)speed);
            if (!wo.m_8055_(check.m_7495_()).m_60767_().m_76333_()) {
                wo.m_7731_(check.m_7495_(), ((Block)ModBlocks.MI_SCAFFOLDING.get()).m_49966_(), 3);
            }
        }
    }

    private double BlockDisHorizontal(BlockPos trt) {
        float f1 = trt.m_123341_() - this.mob.m_20183_().m_123341_();
        float f2 = trt.m_123343_() - this.mob.m_20183_().m_123343_();
        return Math.sqrt(f1 * f1 + f2 * f2);
    }

    private double BlockDisTotal(BlockPos trt) {
        float f1 = trt.m_123341_() - this.mob.m_20183_().m_123341_();
        float f2 = trt.m_123343_() - this.mob.m_20183_().m_123343_();
        float f3 = Math.abs(trt.m_123342_() - this.mob.m_20183_().m_123342_());
        return Math.sqrt(f1 * f1 + f2 * f2) + (double)f3;
    }

    private void mineAndReplace(BlockPos pos) {
        BlockState stat = this.mob.m_9236_().m_8055_(pos);
        if (stat.m_60795_()) {
            return;
        }
        if (this.mob.canBeMined(stat)) {
            this.blockStateList.add(stat);
            this.blockPosList.add(pos);
            this.mob.m_9236_().m_46961_(pos, false);
            if (this.blockStateList.size() > 6) {
                this.mob.m_9236_().m_7731_(this.blockPosList.get(0), this.blockStateList.get(0), 3);
                this.blockStateList.remove(0);
                this.blockPosList.remove(0);
            }
        }
    }

    private void informAllies() {
        if (this.PlayPos() == null) {
            return;
        }
        this.mob.m_5496_((SoundEvent)ModSounds.SFX_TRACKER_STATIC.get(), 4.0f, 1.0f);
        for (EntityMi mi : this.transmitMis()) {
            mi.setPatrolTarget(this.PlayPos());
        }
    }

    private List<EntityMi> transmitMis() {
        return this.mob.f_19853_.m_6443_(EntityMi.class, this.mob.m_20191_().m_82377_(196.0, 64.0, 196.0), p_226543_1_ -> p_226543_1_.getOwner() == this.mob.getOwner() && (p_226543_1_.MissionType == "Scout" || p_226543_1_.MissionType == "Explore" || p_226543_1_.MissionType == "Guardian" || p_226543_1_.MissionType == "Hunt"));
    }

    private boolean enemyNearby() {
        return !this.mob.f_19853_.m_6443_(EntityMi.class, this.mob.m_20191_().m_82377_(10.0, 4.0, 10.0), p_226543_1_ -> p_226543_1_.getOwner() != this.mob.getOwner()).isEmpty();
    }

    private void evilSign(SignBlockEntity sign) {
        switch (this.mob.m_217043_().m_188503_(8)) {
            case 0: {
                sign.m_59732_(0, (Component)Component.m_237113_((String)"MI KNOWS"));
                sign.m_59732_(1, (Component)Component.m_237113_((String)"WHERE YOU"));
                sign.m_59732_(2, (Component)Component.m_237113_((String)"LIVE"));
                sign.m_59732_(3, (Component)Component.m_237113_((String)""));
                break;
            }
            case 1: {
                sign.m_59732_(0, (Component)Component.m_237113_((String)"WE ARE"));
                sign.m_59732_(1, (Component)Component.m_237113_((String)"WATCHING YOU"));
                sign.m_59732_(2, (Component)Component.m_237113_((String)""));
                sign.m_59732_(3, (Component)Component.m_237113_((String)""));
                break;
            }
            case 2: {
                sign.m_59732_(0, (Component)Component.m_237113_((String)"MI ALLIANCE"));
                sign.m_59732_(1, (Component)Component.m_237113_((String)"WILL WIN"));
                sign.m_59732_(2, (Component)Component.m_237113_((String)"SURRENDER"));
                sign.m_59732_(3, (Component)Component.m_237113_((String)"WHILE YOU CAN"));
                break;
            }
            case 3: {
                sign.m_59732_(0, (Component)Component.m_237113_((String)"GIVE UP"));
                sign.m_59732_(1, (Component)Component.m_237113_((String)"GIVE UP"));
                sign.m_59732_(2, (Component)Component.m_237113_((String)"GIVE UP"));
                sign.m_59732_(3, (Component)Component.m_237113_((String)"GIVE UP"));
                break;
            }
            case 4: {
                sign.m_59732_(0, (Component)Component.m_237113_((String)"I WILL"));
                sign.m_59732_(1, (Component)Component.m_237113_((String)"FIND YOU"));
                sign.m_59732_(2, (Component)Component.m_237113_((String)"I WILL"));
                sign.m_59732_(3, (Component)Component.m_237113_((String)"KILL YOU"));
                break;
            }
            case 5: {
                sign.m_59732_(0, (Component)Component.m_237113_((String)"WATCH"));
                sign.m_59732_(1, (Component)Component.m_237113_((String)"YOUR BACK"));
                sign.m_59732_(2, (Component)Component.m_237113_((String)"I AM ALWAYS"));
                sign.m_59732_(3, (Component)Component.m_237113_((String)"HERE"));
                break;
            }
            case 6: {
                sign.m_59732_(0, (Component)Component.m_237113_((String)"NOWHERE"));
                sign.m_59732_(1, (Component)Component.m_237113_((String)"IS SAFE"));
                sign.m_59732_(2, (Component)Component.m_237113_((String)"I AM"));
                sign.m_59732_(3, (Component)Component.m_237113_((String)"THE SHADOW"));
                break;
            }
            case 7: {
                sign.m_59732_(0, (Component)Component.m_237113_((String)"OUR WORLD"));
                sign.m_59732_(1, (Component)Component.m_237113_((String)"OUR WAR"));
                sign.m_59732_(2, (Component)Component.m_237113_((String)"OUR RULES"));
                sign.m_59732_(3, (Component)Component.m_237113_((String)"OUR VICTORY"));
            }
        }
    }
}

