/*
 * Decompiled with CFR 0.152.
 */
package entities;

import block.ModBlocks;
import com.mialliance.ModSounds;
import entities.EntityAbstractLegacy;
import entities.EntityMi;
import item.ModItems;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class EntityLegacian
extends EntityAbstractLegacy {
    public LeapAtTargetGoal leapGoal;
    public GhostGoal ghostGoal;
    public HurtGoal hurtGoal;
    public int fade = -1;
    public int mission = 0;
    public int giveItem = 0;

    public EntityLegacian(EntityType<? extends EntityLegacian> p_i48549_1_, Level p_i48549_2_) {
        super(p_i48549_1_, p_i48549_2_);
        this.f_21364_ = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.addBehaviourGoals();
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    protected void addBehaviourGoals() {
        this.leapGoal = new LeapAtTargetGoal(this, 0.25f);
        this.ghostGoal = new GhostGoal(this);
        this.hurtGoal = new HurtGoal((Mob)this, new Class[0]);
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(3, (Goal)this.leapGoal);
        this.f_21345_.m_25352_(1, (Goal)this.ghostGoal);
        this.f_21345_.m_25352_(1, (Goal)new CinematicGoal(this));
        this.f_21345_.m_25352_(2, (Goal)this.hurtGoal);
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 10, true, false, (Predicate)new TargetPredicate(this)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22277_, 45.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    public void m_8119_() {
        EntityMi mi;
        if (this.fade > 0) {
            --this.fade;
            if (this.fade == 0) {
                this.m_21373_();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.mission == 3 && this.scanMi().isEmpty()) {
            this.m_21373_();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_5448_() instanceof EntityMi && !(mi = (EntityMi)this.m_5448_()).targetMi()) {
            this.m_6710_(null);
        }
        super.m_8119_();
    }

    private List<EntityMi> scanMi() {
        return this.f_19853_.m_6443_(EntityMi.class, this.m_20191_().m_82377_(48.0, 12.0, 48.0), e -> !e.isTame());
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
    }

    public boolean m_142535_(float p_149717_, float p_149718_, DamageSource p_149719_) {
        return false;
    }

    protected boolean teleportGo() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.f_19796_.m_188503_(2) == 0 ? this.m_20185_() + (14.0 + this.f_19796_.m_188500_() * 10.0) : this.m_20185_() - (14.0 + this.f_19796_.m_188500_() * 10.0);
            double d2 = this.f_19796_.m_188503_(2) == 0 ? this.m_20189_() + (14.0 + this.f_19796_.m_188500_() * 10.0) : this.m_20189_() - (14.0 + this.f_19796_.m_188500_() * 10.0);
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(20) - 4);
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    protected boolean teleportOffense(Entity p_70816_1_) {
        Vec3 vector3d = new Vec3(this.m_20185_() - p_70816_1_.m_20185_(), this.m_20227_(0.5) - p_70816_1_.m_20188_(), this.m_20189_() - p_70816_1_.m_20189_());
        vector3d = vector3d.m_82541_();
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 4.0 - vector3d.f_82479_ * 8.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(8) - 4) - vector3d.f_82480_ * 8.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 4.0 - vector3d.f_82481_ * 8.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos blockpos$mutable = new BlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_(blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable = blockpos$mutable.m_7495_();
        }
        BlockState blockstate = this.f_19853_.m_8055_(blockpos$mutable);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (!super.m_6469_(p_70097_1_, p_70097_2_)) {
            return false;
        }
        return this.f_19853_ instanceof ServerLevel;
    }

    public boolean m_7327_(Entity ta) {
        boolean flag = super.m_7327_(ta);
        if (flag && ta instanceof EntityMi) {
            ((LivingEntity)ta).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 3, true, false));
            ((LivingEntity)ta).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 3, true, false));
        }
        return flag;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.TUBIAN_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSounds.TUBIAN_HIT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.MUSIC_MEMORY.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_11997_;
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public void m_213945_(RandomSource source, DifficultyInstance p_180481_1_) {
        super.m_213945_(source, p_180481_1_);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.TUBIAN_WARSTAFF.get()));
    }

    public void m_7380_(CompoundTag cn) {
        cn.m_128405_("Fade", this.fade);
        cn.m_128405_("Mission", this.mission);
        cn.m_128405_("GiveItem", this.giveItem);
        super.m_7380_(cn);
    }

    public void m_7378_(CompoundTag cn) {
        this.fade = cn.m_128451_("Fade");
        this.mission = cn.m_128451_("Mission");
        this.giveItem = cn.m_128451_("GiveItem");
        super.m_7378_(cn);
    }

    protected float m_6431_(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return 1.74f;
    }

    public boolean m_7252_(ItemStack p_175448_1_) {
        return super.m_7252_(p_175448_1_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        p_213386_4_ = super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.m_213945_(p_213386_1_.m_213780_(), p_213386_2_);
        this.m_213946_(p_213386_1_.m_213780_(), p_213386_2_);
        return p_213386_4_;
    }

    public double m_6049_() {
        return -0.45;
    }

    protected void m_7472_(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.m_7472_(p_213333_1_, p_213333_2_, p_213333_3_);
    }

    public void m_6074_() {
        this.m_21373_();
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    static class LeapAtTargetGoal
    extends Goal {
        private final EntityLegacian mob;
        private LivingEntity target;
        private final float yd;

        public LeapAtTargetGoal(EntityLegacian p_i1630_1_, float p_i1630_2_) {
            this.mob = p_i1630_1_;
            this.yd = p_i1630_2_ * 2.0f;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20160_()) {
                return false;
            }
            this.target = this.mob.m_5448_();
            if (this.target == null) {
                return false;
            }
            double d0 = this.mob.m_20280_((Entity)this.target);
            if (!(d0 > 225.0)) {
                if (!this.mob.m_20096_()) {
                    return false;
                }
                return this.mob.m_217043_().m_188503_(20) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return !this.mob.m_20096_();
        }

        public void m_8056_() {
            if (this.mob.m_217043_().m_188503_(3) == 1) {
                this.mob.teleportOffense((Entity)this.target);
            } else {
                Vec3 vector3d = this.mob.m_20184_();
                Vec3 vector3d1 = new Vec3(this.target.m_20185_() - this.mob.m_20185_(), 0.0, this.target.m_20189_() - this.mob.m_20189_());
                if (vector3d1.m_82556_() > 1.0E-7) {
                    vector3d1 = vector3d1.m_82541_().m_82490_(0.6).m_82549_(vector3d.m_82490_(0.3));
                }
                vector3d1 = this.mob.m_20270_((Entity)this.target) < 1.0f ? vector3d1.m_82542_(-1.0, 0.0, -1.0) : vector3d1.m_82542_(1.5, 0.0, 1.5);
                this.mob.m_20334_(vector3d1.f_82479_, this.yd, vector3d1.f_82481_);
            }
        }
    }

    static class GhostGoal
    extends Goal {
        private final EntityLegacian mob;
        private int inval;
        private List<Player> tt;
        private int state;

        public GhostGoal(EntityLegacian p_i1630_1_) {
            this.mob = p_i1630_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.mob.mission == 1;
        }

        public boolean m_8045_() {
            return this.mob.mission == 1;
        }

        public void m_8056_() {
            this.state = 3 + this.mob.f_19796_.m_188503_(3);
        }

        public void m_8037_() {
            if (--this.inval <= 0) {
                this.inval = 40;
                if (this.mob.m_21225_() != null) {
                    this.mob.m_21373_();
                    this.mob.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                this.tt = this.scanPlayers();
                if (!this.tt.isEmpty()) {
                    this.mob.fade = 3600;
                    if (this.state > 0) {
                        if (this.mob.teleportGo()) {
                            --this.state;
                        } else {
                            this.inval = 1;
                        }
                    } else {
                        this.mob.m_5496_((SoundEvent)ModSounds.MUSIC_ENCOUNTER.get(), 2.0f, 1.0f);
                        this.mob.m_21373_();
                        this.mob.f_19853_.m_7967_((Entity)new ItemEntity(this.mob.f_19853_, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), ((Item)ModItems.MEMORY.get()).m_7968_()));
                        this.mob.f_19853_.m_7731_(this.mob.m_20183_(), ((Block)ModBlocks.FAMILIAR_BLOOM.get()).m_49966_(), 3);
                        this.mob.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
        }

        private List<Player> scanPlayers() {
            return this.mob.f_19853_.m_6443_(Player.class, this.mob.m_20191_().m_82400_(8.0), p_226543_1_ -> true);
        }
    }

    public class HurtGoal
    extends TargetGoal {
        private final TargetingConditions HURT_BY_TARGETING;
        private int timestamp;
        private final Class<?>[] toIgnoreDamage;

        public HurtGoal(Mob p_i50317_1_, Class<?> ... p_i50317_2_) {
            super(p_i50317_1_, true);
            this.HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
            this.toIgnoreDamage = p_i50317_2_;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            int i = this.f_26135_.m_21213_();
            LivingEntity livingentity = this.f_26135_.m_21188_();
            if (i != this.timestamp && livingentity != null) {
                if (livingentity.m_6095_() == EntityType.f_20532_) {
                    return false;
                }
                for (Class<?> oclass : this.toIgnoreDamage) {
                    if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                    return false;
                }
                return this.m_26150_(livingentity, this.HURT_BY_TARGETING);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.f_26135_.m_21188_());
            this.f_26137_ = this.f_26135_.m_5448_();
            this.timestamp = this.f_26135_.m_21213_();
            this.f_26138_ = 300;
            super.m_8056_();
        }
    }

    static class CinematicGoal
    extends Goal {
        private final EntityLegacian mob;
        private int inval;
        private List<Player> tt;
        private int counter;

        public CinematicGoal(EntityLegacian p_i1630_1_) {
            this.mob = p_i1630_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.mission == 2;
        }

        public boolean m_8045_() {
            return this.mob.mission == 2;
        }

        public void m_8056_() {
            this.counter = 200;
            this.mob.m_20331_(true);
        }

        public void m_8037_() {
            --this.counter;
            if (this.counter < 1) {
                Item ii = (Item)ModItems.FRAGMENT_OF_RESISTANCE1.get();
                switch (this.mob.giveItem) {
                    case 2: {
                        ii = (Item)ModItems.FRAGMENT_OF_RESISTANCE2.get();
                        break;
                    }
                    case 3: {
                        ii = (Item)ModItems.FRAGMENT_OF_RESISTANCE3.get();
                        break;
                    }
                    case 4: {
                        ii = this.mob.f_19796_.m_188499_() ? (Item)ModItems.TUBIAN_PRISM.get() : (Item)ModItems.BROKEN_STANDARD.get();
                    }
                }
                this.mob.m_19983_(ii.m_7968_());
                this.mob.m_21373_();
                this.mob.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (--this.inval <= 0) {
                this.inval = 40;
                this.tt = this.scanPlayers();
                double disto = 9999.0;
                Player tot = null;
                for (Player pl : this.tt) {
                    if (!((double)this.mob.m_20270_((Entity)pl) < disto)) continue;
                    disto = this.mob.m_20270_((Entity)pl);
                    tot = pl;
                }
                if (tot != null) {
                    this.mob.m_21391_((Entity)tot, 5.0f, 5.0f);
                }
            }
        }

        private List<Player> scanPlayers() {
            return this.mob.f_19853_.m_6443_(Player.class, this.mob.m_20191_().m_82400_(16.0), p_226543_1_ -> true);
        }
    }

    static class TargetPredicate
    implements Predicate<LivingEntity> {
        public TargetPredicate(EntityLegacian p_i45832_1_) {
        }

        @Override
        public boolean test(@Nullable LivingEntity p_test_1_) {
            if (p_test_1_ instanceof EntityMi) {
                EntityMi other = (EntityMi)p_test_1_;
                if (!other.targetMi()) {
                    return false;
                }
                if (!other.isTame() && other.Weapon != "Train") {
                    return true;
                }
            } else if (p_test_1_ instanceof Monster) {
                return true;
            }
            return false;
        }
    }
}

