/*
 * Decompiled with CFR 0.152.
 */
package entities;

import com.mialliance.MiCon;
import entities.EntityMi;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityBombimi
extends EntityMi {
    private int lifetime = 100;
    public boolean isGrenade = false;
    public boolean isShell = false;
    public boolean isBreach = false;
    public boolean isFlak = false;
    public boolean isLightShell = false;

    public EntityBombimi(EntityType<? extends EntityBombimi> p_i50195_1_, Level p_i50195_2_) {
        super((EntityType<? extends EntityMi>)p_i50195_1_, p_i50195_2_);
        this.f_21364_ = 0;
    }

    @Override
    protected void m_8099_() {
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean targetMi() {
        return false;
    }

    public void setGrenade() {
        this.isGrenade = true;
        this.lifetime = 35 + this.f_19796_.m_188503_(10);
    }

    public void setLightShell() {
        this.isLightShell = true;
        this.lifetime = 12 + this.f_19796_.m_188503_(2);
    }

    public void setMortar() {
        this.isShell = true;
        this.lifetime = 55 + this.f_19796_.m_188503_(10);
    }

    public void setShell() {
        this.isShell = true;
        this.lifetime = 12 + this.f_19796_.m_188503_(2);
    }

    public void setBreach() {
        this.isBreach = true;
        this.lifetime = 30 + this.f_19796_.m_188503_(10);
    }

    public void setFlak() {
        this.isFlak = true;
        this.lifetime = 15;
    }

    @Override
    protected float m_6431_(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return 0.15f;
    }

    @Override
    protected PathNavigation m_6037_(Level p_175447_1_) {
        return new GroundPathNavigation((Mob)this, p_175447_1_);
    }

    @Override
    public void m_8107_() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.2), this.m_20187_(), this.m_20262_(0.2), 0.0, 0.0, 0.0);
        super.m_8107_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 96.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public void m_8119_() {
        if (!this.isGrenade && !this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_76178_()) {
            this.lifetime = 0;
        }
        if (this.lifetime-- < 1) {
            this.m_6074_();
        }
        if ((this.isShell || this.isLightShell) && !this.findBlastVictims(1.5).isEmpty() && this.lifetime < 6) {
            this.m_6074_();
        }
        if (this.isFlak && !this.findFlakVictims(7.0).isEmpty() && this.lifetime < 6) {
            this.m_6074_();
        }
        super.m_8119_();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return null;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11913_;
    }

    @Override
    public void m_6667_(DamageSource p_70645_1_) {
        boolean boom = (Boolean)MiCon.GRIEFING_FIRE.get();
        Explosion.BlockInteraction blast = (Boolean)MiCon.GRIEFING_DESTRUCTION.get() != false ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
        BlockPos heh = this.m_20183_();
        if (this.isGrenade) {
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), (double)(heh.m_123342_() + 1), this.m_20189_(), 2.5f, Explosion.BlockInteraction.NONE);
        } else if (this.isShell) {
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), (double)(heh.m_123342_() + 1), this.m_20189_(), 1.5f, Explosion.BlockInteraction.NONE);
            for (LivingEntity ent : this.findBlastVictims(3.5)) {
                float dmg = 9.0f;
                if (this.isForeign((Entity)ent)) {
                    dmg = 21.0f;
                }
                ent.m_6469_(DamageSource.m_19373_((LivingEntity)this), 6.0f);
            }
        } else if (this.isLightShell) {
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), (double)(heh.m_123342_() + 1), this.m_20189_(), 1.5f, Explosion.BlockInteraction.NONE);
            for (LivingEntity ent : this.findBlastVictims(3.0)) {
                float dmg = 7.0f;
                if (this.isForeign((Entity)ent)) {
                    dmg = 18.0f;
                }
                ent.m_6469_(DamageSource.m_19373_((LivingEntity)this), 6.0f);
            }
        } else if (this.isFlak) {
            for (LivingEntity ent : this.findFlakVictims(10.0)) {
                ent.m_6469_(DamageSource.m_19373_((LivingEntity)this), 14.0f);
                ent.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20, 3, false, false));
            }
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), (double)heh.m_123342_(), this.m_20189_(), 2.0f, Explosion.BlockInteraction.NONE);
        } else if (this.isBreach) {
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), (double)heh.m_123342_(), this.m_20189_(), 2.5f, boom, blast);
        } else {
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), (double)(heh.m_123342_() + 1), this.m_20189_(), 1.0f, boom, Explosion.BlockInteraction.NONE);
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), (double)(heh.m_123342_() + 1), this.m_20189_(), 2.5f, Explosion.BlockInteraction.NONE);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        super.m_6667_(p_70645_1_);
    }

    private List<LivingEntity> findBlastVictims(double rad) {
        return this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(rad), ent -> {
            if (ent instanceof EntityMi) {
                EntityMi mi = (EntityMi)((Object)ent);
                return mi.getOwner() != this.getOwner();
            }
            return ent != this.getOwner();
        });
    }

    private List<LivingEntity> findFlakVictims(double rad) {
        return this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(rad), ent -> {
            if (ent.m_20096_()) {
                return false;
            }
            if (ent instanceof EntityMi) {
                EntityMi mi = (EntityMi)((Object)ent);
                return mi.getOwner() != this.getOwner();
            }
            return ent != this.getOwner();
        });
    }

    public boolean m_7337_(Entity p_241849_1_) {
        return false;
    }

    @Override
    public void m_5618_(float p_181013_1_) {
        if (this.m_20184_() != new Vec3(0.0, 0.0, 0.0)) {
            this.m_146922_(p_181013_1_);
            super.m_5618_(p_181013_1_);
        }
    }
}

