/*
 * Decompiled with CFR 0.152.
 */
package entities;

import block.ModBlocks;
import com.mialliance.MiCon;
import entities.BillooAttackGoal;
import entities.BillooRunGoal;
import entities.EntityLoon;
import entities.EntityMi;
import entities.EntityPatrollus;
import entities.IMiRide;
import entities.MiFlyerColonyOrder;
import entities.MiFlyerDescend;
import entities.MiFlyerFollowOrder;
import entities.MiFlyerGuardOrder;
import entities.MiSearchGoal;
import entities.ModEntities;
import item.ItemBombimi;
import item.ItemMiridiumController;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class EntityBilloo
extends EntityMi
implements IMiRide {
    private static final EntityDataAccessor<Boolean> DATA_ID_BOMBING = SynchedEntityData.m_135353_(EntityMi.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int CargoMis = 0;
    int CargoBombs = 0;
    int GoDeploy = 0;
    protected BlockPos PickupQuest = null;
    protected boolean TransportQuest = false;
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.m_135353_(EntityLoon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME = SynchedEntityData.m_135353_(EntityLoon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemBasedSteering steering = new ItemBasedSteering(this.f_19804_, DATA_BOOST_TIME, DATA_SADDLE_ID);
    boolean SpecialUpgrade = false;

    public EntityBilloo(EntityType<? extends EntityBilloo> p_i50195_1_, Level p_i50195_2_) {
        super((EntityType<? extends EntityMi>)p_i50195_1_, p_i50195_2_);
        this.f_21364_ = 50;
    }

    @Override
    public boolean boost() {
        return false;
    }

    @Override
    public void travelWithInput(Vec3 p_230267_1_) {
        super.m_7023_(p_230267_1_);
    }

    @Override
    public void m_7023_(Vec3 p_213352_1_) {
        this.travel(this, this.steering, p_213352_1_);
    }

    @Override
    public float getSteeringSpeed() {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.7f;
    }

    public boolean giveSpecialUpgrade() {
        if (this.SpecialUpgrade) {
            return false;
        }
        this.SpecialUpgrade = true;
        this.setMiHealth();
        return true;
    }

    public boolean hasSpecialUpgrade() {
        return this.SpecialUpgrade;
    }

    @Override
    public float mi_health_extra_buffs() {
        if (this.SpecialUpgrade) {
            return 25.0f;
        }
        return 0.0f;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BillooRunGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new Drive(this));
        this.f_21345_.m_25352_(5, (Goal)new BillooAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new Pickup(this));
        this.f_21345_.m_25352_(7, new EntityPatrollus.PatrolGoal<EntityBilloo>(this, 1.0, 0.85));
        this.f_21345_.m_25352_(4, (Goal)new MiFlyerDescend(this));
        this.f_21345_.m_25352_(6, (Goal)new MiFlyerFollowOrder(this));
        this.f_21345_.m_25352_(6, (Goal)new MiFlyerGuardOrder(this));
        this.f_21345_.m_25352_(6, (Goal)new MiFlyerColonyOrder(this));
        this.f_21346_.m_25352_(2, new MiSearchGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, new EntityMi.TargetPredicate(this)));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_BOMBING, (Object)false);
    }

    public void setBombing(boolean p_175463_1_) {
        this.f_19804_.m_135381_(DATA_ID_BOMBING, (Object)p_175463_1_);
    }

    public boolean isBombing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_BOMBING);
    }

    public void setPickup(BlockPos pos) {
        this.PickupQuest = pos;
        this.TransportQuest = true;
        this.CargoBombs = 0;
        this.CargoMis = 0;
        this.canAttack = false;
    }

    @Override
    public void m_6504_(LivingEntity p_82196_1_, float p_82196_2_) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrowentity = this.getArrow(itemstack, p_82196_2_);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double d0 = p_82196_1_.m_20185_() - this.m_20185_();
        double d1 = p_82196_1_.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
        double d2 = p_82196_1_.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        double dist = this.m_20270_((Entity)this.m_5448_()) / 80.0f;
        double height = 1.0 + (p_82196_1_.m_20186_() - this.m_20186_()) * 0.05;
        float spd = 2.4f;
        if (this.m_20186_() - 1.0 > this.m_5448_().m_20186_()) {
            abstractarrowentity.m_6027_(abstractarrowentity.m_20185_() - 2.0 + (double)(this.f_19796_.m_188501_() * 4.0f), abstractarrowentity.m_20186_() - 0.5, abstractarrowentity.m_20189_() - 2.0 + (double)(this.f_19796_.m_188501_() * 4.0f));
        }
        height = 1.0 + (p_82196_1_.m_20186_() - this.m_20186_()) * 0.02;
        abstractarrowentity.m_6686_(d0, d1 + d3 * dist * height + 0.1, d2, spd, 12.0f);
        abstractarrowentity.m_36781_(3.0);
        if (this.SpecialUpgrade) {
            abstractarrowentity.m_36781_(4.0);
        }
        this.m_5496_(SoundEvents.f_11798_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    @Override
    public void m_8107_() {
        if (this.isBombing()) {
            this.setBombing(false);
            for (int i = 0; i < 14; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.1), this.m_20182_().m_7098_() - 0.5, this.m_20262_(0.1), this.m_217043_().m_188583_() * 0.1 - 0.05, -0.08, this.m_217043_().m_188583_() * 0.1 - 0.05);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.1), this.m_20182_().m_7098_() - 0.5, this.m_20262_(0.1), this.m_217043_().m_188583_() * 0.3 - 0.15, -0.14, this.m_217043_().m_188583_() * 0.3 - 0.15);
            }
        }
        super.m_8107_();
    }

    @Override
    public double m_6049_() {
        return 0.5;
    }

    public double m_6048_() {
        return -1.3;
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    @Override
    public void m_8119_() {
        this.moveFirst = true;
        super.m_8119_();
    }

    @Override
    protected double getBonus() {
        return (Double)MiCon.BILLOO_HP_BONUS.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 96.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    @Override
    public float mi_health_standard() {
        return 60.0f;
    }

    @Override
    public float mi_health_armor1_bonus() {
        return 20.0f;
    }

    @Override
    public float mi_health_armor2_bonus() {
        return 40.0f;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Mis", this.CargoMis);
        nbt.m_128405_("Bombs", this.CargoBombs);
        nbt.m_128379_("Transport", this.TransportQuest);
        if (this.PickupQuest != null) {
            nbt.m_128365_("Pickup", (Tag)NbtUtils.m_129224_((BlockPos)this.PickupQuest));
        }
    }

    @Override
    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        this.CargoMis = p_70037_1_.m_128451_("Mis");
        this.CargoBombs = p_70037_1_.m_128451_("Bombs");
        this.TransportQuest = p_70037_1_.m_128471_("Transport");
        if (p_70037_1_.m_128441_("Pickup")) {
            this.PickupQuest = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("Pickup"));
        }
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    @Override
    protected SoundEvent m_7515_() {
        return null;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return null;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11913_;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        if (p_213386_3_ != MobSpawnType.CONVERSION && !this.isTame()) {
            if (this.Weapon == "Empty") {
                this.PickupQuest = this.m_20183_();
                this.TransportQuest = true;
                this.Weapon = "";
            } else if (this.f_19796_.m_188499_()) {
                this.CargoBombs = 5 + this.f_19796_.m_188503_(3);
            } else if (this.PickupQuest == null) {
                for (int i = 0; i < 4; ++i) {
                    String sto = "Spear";
                    if (this.m_217043_().m_188499_()) {
                        sto = "Bow";
                    } else if (this.m_217043_().m_188499_()) {
                        sto = "Sword";
                    }
                    EntityMi mi = this.spawnMiTarget((EntityType)ModEntities.MI.get(), null, sto, this.f_19853_, this.m_20183_().m_7494_(), false);
                    mi.m_20329_((Entity)this);
                    if (this.PowerLevel <= 3) continue;
                    mi.equipMiridium();
                }
            }
        }
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModBlocks.MITREAN_GLASS.get()));
        this.m_21409_(EquipmentSlot.HEAD, 0.0f);
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    @Override
    public void m_5618_(float p_181013_1_) {
        if (this.m_20184_() != new Vec3(0.0, 0.0, 0.0)) {
            this.m_146922_(p_181013_1_);
            super.m_5618_(p_181013_1_);
        }
    }

    @Nullable
    public Entity m_6688_() {
        if (this.m_20197_().isEmpty()) {
            return null;
        }
        if (!this.CheckPotentialPlayerHostility((Entity)this.m_20197_().get(0))) {
            return (Entity)this.m_20197_().get(0);
        }
        return null;
    }

    @Override
    public boolean m_7310_(Entity p_184219_1_) {
        return this.m_20197_().size() < 6;
    }

    @Override
    public boolean isSpecialMover() {
        return true;
    }

    @Override
    public InteractionResult m_6071_(Player pl, InteractionHand hd) {
        if (!pl.m_21205_().m_41619_()) {
            if (pl.m_21205_().m_41720_() instanceof ItemBombimi && this.CargoBombs < 9) {
                ++this.CargoBombs;
                pl.m_21205_().m_41774_(1);
            }
            super.m_6071_(pl, hd);
        } else if (this.m_20197_().size() < 6 && !this.CheckPlayerHostility(pl)) {
            pl.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7332_(Entity p_184232_1_) {
        if (this.m_20363_(p_184232_1_)) {
            float f = 0.0f;
            float side = 0.0f;
            float f1 = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + p_184232_1_.m_6049_());
            if (this.m_20197_().size() > 0) {
                int i = this.m_20197_().indexOf(p_184232_1_);
                switch (i) {
                    case 0: {
                        f = 1.2f;
                        side = 0.0f;
                        break;
                    }
                    case 1: {
                        f = -1.2f;
                        side = 0.0f;
                        break;
                    }
                    case 2: {
                        f = 0.4f;
                        side = 1.0f;
                        break;
                    }
                    case 3: {
                        f = 0.4f;
                        side = -1.0f;
                        break;
                    }
                    case 4: {
                        f = -0.4f;
                        side = 1.0f;
                        break;
                    }
                    case 5: {
                        f = -0.4f;
                        side = -1.0f;
                    }
                }
            }
            Vec3 vector3d = new Vec3((double)f, 0.0, (double)side).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            p_184232_1_.m_6034_(this.m_20185_() + vector3d.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vector3d.f_82481_);
        }
    }

    @Override
    public void DriveMi() {
        double spd = 0.4;
        if (((LivingEntity)this.m_6688_()).m_21205_().m_41720_() instanceof ItemMiridiumController) {
            spd = 0.7;
        }
        if (this.SpecialUpgrade) {
            spd += 0.15;
        }
        for (Entity ent : this.m_20197_()) {
            if (!(ent instanceof LivingEntity)) continue;
            ((LivingEntity)ent).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0, false, false));
        }
        if (((LivingEntity)this.m_6688_()).f_20902_ > 0.0f) {
            Vec3 go = this.m_6688_().m_20252_(1.0f).m_82541_().m_82542_(spd, spd, spd);
            this.m_20256_(go);
            Vec3 vec3 = this.m_20184_();
        }
        this.moveFirst = false;
    }

    static class Drive
    extends Goal {
        private final EntityBilloo mob;

        public Drive(EntityBilloo p_i1630_1_) {
            this.mob = p_i1630_1_;
        }

        public boolean m_8036_() {
            return this.mob.isTame() && this.mob.m_20160_() && this.mob.m_6688_() != null;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.mob.flyTarget = null;
        }

        public void m_8037_() {
            double spd = 0.4;
            if (((LivingEntity)this.mob.m_6688_()).m_21205_().m_41720_() instanceof ItemMiridiumController) {
                spd = 0.7;
            }
            if (this.mob.SpecialUpgrade) {
                spd += 0.15;
            }
            for (Entity ent : this.mob.m_20197_()) {
                if (!(ent instanceof LivingEntity)) continue;
                ((LivingEntity)ent).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0, false, false));
            }
            if (((LivingEntity)this.mob.m_6688_()).f_20902_ > 0.0f) {
                Vec3 go = this.mob.m_6688_().m_20252_(1.0f).m_82541_().m_82542_(spd, spd, spd);
                this.mob.m_20256_(go);
                Vec3 vector3d = this.mob.m_20184_();
                this.mob.m_146922_(-((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f);
                this.mob.f_20883_ = this.mob.m_146908_();
                this.mob.f_19859_ = this.mob.m_146908_();
                this.mob.f_20884_ = this.mob.m_146908_();
            }
            this.mob.moveFirst = false;
        }

        public void m_8041_() {
            this.mob.flyTarget = null;
            this.mob.FlightNavigate(this.mob.m_20183_(), 1.0, "Close");
        }
    }

    static class Pickup
    extends Goal {
        private final EntityBilloo mob;
        int testo = 0;

        public Pickup(EntityBilloo p_i1630_1_) {
            this.mob = p_i1630_1_;
        }

        public boolean m_8036_() {
            if (this.mob.PickupQuest == null) {
                return false;
            }
            ++this.testo;
            return this.testo > 39;
        }

        public boolean m_8045_() {
            return this.mob.PickupQuest != null;
        }

        public void m_8056_() {
            this.mob.flyTarget = null;
        }

        public void m_8037_() {
            this.testo = 0;
            if (this.mob.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.mob.m_20183_()).m_123342_() > 10) {
                if (this.mob.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.mob.m_20183_().m_122013_(5)).m_123342_() < 10) {
                    return;
                }
                if (this.mob.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.mob.m_20183_().m_122020_(5)).m_123342_() < 10) {
                    return;
                }
                if (this.mob.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.mob.m_20183_().m_122025_(5)).m_123342_() < 10) {
                    return;
                }
                if (this.mob.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.mob.m_20183_().m_122030_(5)).m_123342_() < 10) {
                    return;
                }
                this.mob.PickupQuest = null;
                for (Entity ent : this.mob.m_20197_()) {
                    if (ent instanceof LivingEntity) {
                        ((LivingEntity)ent).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0, false, false));
                    }
                    ent.m_8127_();
                }
            }
        }

        public void m_8041_() {
        }
    }
}

