/*
 * Decompiled with CFR 0.152.
 */
package entities;

import com.mialliance.ModSounds;
import entities.EntityBilloo;
import entities.EntityMi;
import entities.ModEntities;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class BillooAttackGoal
extends Goal {
    protected final EntityBilloo mob;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private int bombing = 0;

    public BillooAttackGoal(EntityBilloo p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
        this.mob = p_i1636_1_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.mob.f_19853_.m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null || !this.mob.canAttack) {
            return false;
        }
        return livingentity.m_6084_();
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            if (this.bombing > 0) {
                ++this.bombing;
                if (this.bombing > 20) {
                    this.bombing = 0;
                }
            }
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.ticksUntilNextPathRecalculation <= 0) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                BlockPos target = new BlockPos(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ);
                target = this.mob.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, target);
                this.ticksUntilNextPathRecalculation = 4;
                if (this.mob.m_6688_() == null) {
                    this.mob.FlightNavigate(target, 1.2, "Engage");
                }
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingentity, d0);
        }
    }

    protected void checkAndPerformAttack(LivingEntity p_190102_1_, double p_190102_2_) {
        double d0 = 16000.0;
        if (p_190102_2_ <= d0 && this.ticksUntilNextAttack < 20 && this.mob.m_217043_().m_188503_(4) == 0) {
            this.mob.m_6504_(p_190102_1_, 1.0f);
            if (this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
            }
        }
        double hdis = Math.sqrt(Math.abs(this.mob.m_20185_() - p_190102_1_.m_20185_()) * Math.abs(this.mob.m_20185_() - p_190102_1_.m_20185_()) + Math.abs(this.mob.m_20189_() - p_190102_1_.m_20189_()) * Math.abs(this.mob.m_20189_() - p_190102_1_.m_20189_()));
        if (this.mob.GoDeploy < 1 && this.bombing == 0 && (this.mob.isTargetThreat() || this.mob.m_21223_() < 50.0f || this.mob.isTame())) {
            if (hdis < 6.0 && this.mob.CargoBombs > 0 && this.mob.m_217043_().m_188503_(20) == 0) {
                this.mob.m_5496_((SoundEvent)ModSounds.MUSIC_MORTAR.get(), 2.0f, 1.0f);
                --this.mob.CargoBombs;
                this.bombing = 1;
                this.mob.GoDeploy = 40;
                this.mob.setBombing(true);
                EntityMi bomb = this.mob.spawnMiProjectile((EntityType)ModEntities.BOMBIMI.get(), this.mob.f_19853_, this.mob.m_20182_(), this.mob);
                if (this.mob.isTame()) {
                    bomb.tame(this.mob.getOwnerUUID());
                }
                bomb.m_20256_(this.mob.m_20184_());
            }
            if (hdis < 14.0 && this.mob.m_20197_().size() > 0 && this.mob.m_217043_().m_188503_(20) == 0 && this.mob.m_6688_() == null) {
                double xdir = p_190102_1_.m_20185_() - this.mob.m_20185_();
                double zdir = p_190102_1_.m_20189_() - this.mob.m_20189_();
                this.mob.m_5496_((SoundEvent)ModSounds.MUSIC_NOTE.get(), 2.0f, 1.0f);
                Vec3 vector3d1 = new Vec3(xdir / 15.0, 0.1, zdir / 15.0);
                EntityMi mi = (EntityMi)((Object)this.mob.m_20197_().get(0));
                mi.Tactic = "Descend";
                mi.TacticPos = p_190102_1_.m_20183_();
                mi.MissionType = "Hunt";
                mi.m_8127_();
                mi.m_20334_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_);
                this.mob.GoDeploy = 20;
            }
        } else {
            --this.mob.GoDeploy;
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 50 + this.mob.m_217043_().m_188503_(30);
        if (this.mob.f_19853_.m_46791_() == Difficulty.HARD) {
            this.ticksUntilNextAttack -= 10;
        }
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }
}

