/*
 * Decompiled with CFR 0.152.
 */
package block;

import block.ModTileEntities;
import com.mialliance.MiCon;
import entities.EntityMi;
import entities.ModEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class TileEntityEmbassy
extends BlockEntity {
    public double pri = 50.0;
    public boolean isStaffed = false;
    public boolean gainPri = false;
    public int savePhase = 1;
    public int idleTime = 250;
    public int exchangeTime = 0;
    public BlockPos exchangeTarget;
    public int exchange = 0;
    public int truceTime = 0;
    public int powerLevel = 0;
    public int stronk = 0;
    private int announceSide = 1;
    public int idleTarget = 450;

    public TileEntityEmbassy(BlockPos p_155397_, BlockState p_155398_) {
        super((BlockEntityType)ModTileEntities.EMBASSY.get(), p_155397_, p_155398_);
    }

    public static void serverTick(Level lev, BlockPos p, BlockState p_155406_, TileEntityEmbassy dis) {
        long i = lev.m_46467_();
        if (i % 200L == 0L && dis.isStaffed) {
            EntityMi mi;
            List<EntityMi> staff;
            RandomSource rr = lev.m_213780_();
            ++dis.idleTime;
            dis.isStaffed = false;
            if (dis.gainPri) {
                dis.gainPri = false;
                dis.pri += ((Double)MiCon.MI_DIPLOMACY_CHARISMA.get()).doubleValue();
            }
            if (dis.pri > 900.0) {
                dis.pri = 900.0;
            }
            if (dis.pri < 0.0) {
                dis.pri = 0.0;
            }
            if (dis.pri > 600.0 && dis.announceSide < 2 && dis.staffTrue(staff = dis.getStaff())) {
                dis.announceSide = 2;
                dis.idleTime -= 30;
                mi = staff.get(0);
                mi.ObjectiveProgress = 8;
            }
            if (dis.pri < 25.0 && dis.announceSide > 0 && !(staff = dis.getStaff()).isEmpty()) {
                dis.announceSide = 0;
                dis.idleTime -= 30;
                mi = staff.get(0);
                mi.ObjectiveProgress = 10;
            }
            if (dis.exchange > 0) {
                --dis.exchangeTime;
                if (dis.exchangeTime < 1) {
                    staff = dis.getStaff();
                    if (!dis.staffTrue(staff)) {
                        return;
                    }
                    mi = staff.get(0);
                    switch (dis.exchange) {
                        case 1: {
                            mi.ObjectiveProgress = 7;
                            if (dis.idleTime <= dis.idleTarget - 15) break;
                            dis.idleTime = dis.idleTarget - 15;
                            break;
                        }
                        case 4: {
                            dis.spawnAttackers();
                        }
                    }
                    dis.exchange = 0;
                    dis.exchangeTime = 0;
                    dis.exchangeTarget = null;
                }
            }
            if (dis.truceTime > 0) {
                --dis.truceTime;
            }
            if (dis.pri > 50.0 && dis.idleTime > dis.idleTarget) {
                staff = dis.getStaff();
                if (rr.m_188503_(8) == 0 && dis.staffTrue(staff)) {
                    mi = staff.get(0);
                    mi.ObjectiveProgress = 5;
                    dis.idleTime = 0;
                }
            }
        }
    }

    private boolean staffTrue(List<EntityMi> staff) {
        if (staff == null) {
            return false;
        }
        return !staff.isEmpty();
    }

    protected void print(String str) {
    }

    public void announceArmy() {
        List<EntityMi> staff = this.getStaff();
        if (this.staffTrue(staff)) {
            EntityMi mi = staff.get(0);
            this.idleTime = 50;
            mi.ObjectiveProgress = 12;
        }
    }

    public void announceColony() {
        List<EntityMi> staff = this.getStaff();
        if (this.staffTrue(staff)) {
            EntityMi mi = staff.get(0);
            this.idleTime -= 30;
            mi.ObjectiveProgress = 14;
        }
    }

    private List<EntityMi> getStaff() {
        Level lev = this.f_58857_;
        int k = this.f_58858_.m_123341_();
        int l = this.f_58858_.m_123342_();
        int i1 = this.f_58858_.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(12.0, 8.0, 12.0);
        List list = lev.m_45976_(EntityMi.class, axisalignedbb);
        List list2 = lev.m_45976_(EntityMi.class, axisalignedbb);
        for (EntityMi mi : list2) {
            if (mi.MissionType == "Diplomacy" && mi.ObjectiveTarget.m_123341_() == this.m_58899_().m_123341_() && mi.ObjectiveTarget.m_123343_() == this.m_58899_().m_123343_() && mi.ObjectiveProgress == 4) continue;
            list.remove((Object)mi);
        }
        if (list.isEmpty()) {
            return new ArrayList<EntityMi>();
        }
        return list;
    }

    private void spawnAttackers() {
        Level lev = this.f_58857_;
        RandomSource r = lev.f_46441_;
        int pts = 140 + this.powerLevel * 20;
        float diff = 0.8f;
        if (lev.m_46791_() == Difficulty.NORMAL) {
            diff = 1.0f;
        } else if (lev.m_46791_() == Difficulty.HARD) {
            diff = 1.2f;
        }
        diff = this.nearbyPlayers().size() > 3 ? (float)((double)diff * 2.0) : (diff *= 0.7f + (float)this.nearbyPlayers().size() * 0.3f);
        pts = Math.round(diff * (float)pts);
        int summon = 0;
        BlockPos h = lev.m_5452_(Heightmap.Types.MOTION_BLOCKING, this.exchangeTarget);
        this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "Leader", h);
        while (pts > 15) {
            summon = r.m_188503_(35);
            if (summon < 20) {
                if (summon > 13 && this.powerLevel > 3) {
                    this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "SpearMiridium", h);
                } else {
                    this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "Spear", h);
                }
                pts -= 15;
                continue;
            }
            if (summon < 27) {
                this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "Bow", h);
                pts -= 15;
                continue;
            }
            if (summon < 29) {
                this.spawnMiExpedition((EntityType)ModEntities.MI.get(), "Gem", h);
                pts -= 25;
                continue;
            }
            if (summon < 31) {
                this.spawnMiExpedition((EntityType)ModEntities.COMMANDO.get(), "Bow", h);
                pts -= 25;
                continue;
            }
            if (summon < 33) {
                this.spawnMiExpedition((EntityType)ModEntities.GOOB.get(), "", h);
                pts -= 25;
                continue;
            }
            this.spawnMiExpedition((EntityType)ModEntities.TONK.get(), "", h);
            pts -= 45;
        }
    }

    private List<Player> nearbyPlayers() {
        Level lev = this.f_58857_;
        int k = this.exchangeTarget.m_123341_();
        int l = this.exchangeTarget.m_123342_();
        int i1 = this.exchangeTarget.m_123343_();
        AABB axisalignedbb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82377_(64.0, 32.0, 64.0);
        List list = lev.m_45976_(Player.class, axisalignedbb);
        return list;
    }

    private boolean spawnMiExpedition(EntityType<?> newmi, String wp, BlockPos pio) {
        Level lev = this.f_58857_;
        EntityMi mi = (EntityMi)newmi.m_20615_(lev);
        RandomSource r = lev.f_46441_;
        BlockPos spo = pio.m_7918_(r.m_188503_(17) - 8, 25, r.m_188503_(17) - 8);
        while (lev.m_8055_(spo).m_60767_().m_76337_()) {
            spo = spo.m_7494_();
        }
        mi.m_7678_((double)spo.m_123341_() + 0.5, spo.m_123342_(), (double)spo.m_123343_() + 0.5, 0.0f, 0.0f);
        ((ServerLevel)lev).m_47205_((Entity)mi);
        if (wp == "Leader") {
            mi.Weapon = "Spear";
            mi.setPatrolLeader(true);
            mi.Greeting = true;
        } else {
            mi.Weapon = wp;
        }
        mi.MissionType = "Hunt";
        mi.Tactic = "Descend";
        mi.TacticPos = this.exchangeTarget;
        mi.Ammo = 5;
        mi.PowerLevel = this.powerLevel;
        mi.m_6518_((ServerLevelAccessor)((ServerLevel)lev), lev.m_6436_(this.m_58899_()), MobSpawnType.STRUCTURE, null, null);
        mi.m_21373_();
        return true;
    }

    public void m_183515_(CompoundTag nb) {
        super.m_183515_(nb);
        nb.m_128347_("Pri", this.pri);
        nb.m_128405_("idleTime", this.idleTime);
        nb.m_128405_("truceTime", this.truceTime);
        nb.m_128405_("exchangeTime", this.exchangeTime);
        nb.m_128405_("exchange", this.exchange);
        nb.m_128405_("pow", this.powerLevel);
        nb.m_128405_("announce", this.announceSide);
        nb.m_128405_("Opel", this.savePhase);
        if (this.exchangeTarget != null) {
            nb.m_128365_("exchangeTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.exchangeTarget));
        }
    }

    public void m_142466_(CompoundTag nb) {
        super.m_142466_(nb);
        this.pri = nb.m_128459_("Pri");
        this.idleTime = nb.m_128451_("idleTime");
        this.truceTime = nb.m_128451_("truceTime");
        this.exchangeTime = nb.m_128451_("exchangeTime");
        this.exchange = nb.m_128451_("exchange");
        this.powerLevel = nb.m_128451_("pow");
        this.announceSide = nb.m_128451_("announce");
        this.savePhase = nb.m_128451_("Opel");
        this.exchangeTarget = NbtUtils.m_129239_((CompoundTag)nb.m_128469_("exchangeTarget"));
        this.m_6596_();
    }

    public boolean isTruce() {
        if (!this.isStaffed) {
            return false;
        }
        return this.truceTime > 0;
    }
}

